/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.asyncexecutor;

import java.util.LinkedList;
import java.util.UUID;
import org.activiti.engine.impl.asyncexecutor.AcquireAsyncJobsDueRunnable;
import org.activiti.engine.impl.asyncexecutor.AcquireTimerJobsRunnable;
import org.activiti.engine.impl.asyncexecutor.AsyncExecutor;
import org.activiti.engine.impl.asyncexecutor.DefaultExecuteAsyncRunnableFactory;
import org.activiti.engine.impl.asyncexecutor.ExecuteAsyncRunnableFactory;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAsyncJobExecutor
implements AsyncExecutor {
    private static Logger log = LoggerFactory.getLogger(AbstractAsyncJobExecutor.class);
    protected long keepAliveTime = 5000L;
    protected Thread timerJobAcquisitionThread;
    protected Thread asyncJobAcquisitionThread;
    protected AcquireTimerJobsRunnable timerJobRunnable;
    protected AcquireAsyncJobsDueRunnable asyncJobsDueRunnable;
    protected ExecuteAsyncRunnableFactory executeAsyncRunnableFactory;
    protected boolean isAutoActivate = false;
    protected boolean isActive = false;
    protected int maxTimerJobsPerAcquisition = 1;
    protected int maxAsyncJobsDuePerAcquisition = 1;
    protected int defaultTimerJobAcquireWaitTimeInMillis = 10000;
    protected int defaultAsyncJobAcquireWaitTimeInMillis = 10000;
    protected int defaultQueueSizeFullWaitTime = 0;
    protected String lockOwner = UUID.randomUUID().toString();
    protected int timerLockTimeInMillis = 300000;
    protected int asyncJobLockTimeInMillis = 300000;
    protected int retryWaitTimeInMillis = 500;
    protected LinkedList<JobEntity> temporaryJobQueue = new LinkedList();
    protected CommandExecutor commandExecutor;

    @Override
    public boolean executeAsyncJob(JobEntity job) {
        if (this.isActive) {
            Runnable runnable = this.createRunnableForJob(job);
            boolean result = this.executeAsyncJob(runnable);
            if (!result) {
                this.doUnlockJob(job);
            }
            return result;
        }
        this.temporaryJobQueue.add(job);
        return true;
    }

    protected abstract boolean executeAsyncJob(Runnable var1);

    protected void doUnlockJob(final JobEntity job) {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null) {
            this.unlockJob(job, commandContext);
        } else {
            this.commandExecutor.execute(new Command<Void>(){

                @Override
                public Void execute(CommandContext commandContext) {
                    AbstractAsyncJobExecutor.this.unlockJob(job, commandContext);
                    return null;
                }
            });
        }
    }

    protected void unlockJob(JobEntity job, CommandContext commandContext) {
        commandContext.getJobEntityManager().unacquireJob(job.getId());
    }

    protected Runnable createRunnableForJob(JobEntity job) {
        return this.executeAsyncRunnableFactory.createExecuteAsyncRunnable(job, this.commandExecutor);
    }

    @Override
    public void start() {
        if (this.isActive) {
            return;
        }
        log.info("Starting up the default async job executor [{}].", (Object)this.getClass().getName());
        this.initialize();
        this.startExecutingAsyncJobs();
        this.isActive = true;
        while (!this.temporaryJobQueue.isEmpty()) {
            JobEntity job = this.temporaryJobQueue.pop();
            this.executeAsyncJob(job);
        }
        this.isActive = true;
    }

    protected void initialize() {
        if (this.timerJobRunnable == null) {
            this.timerJobRunnable = new AcquireTimerJobsRunnable(this);
        }
        if (this.asyncJobsDueRunnable == null) {
            this.asyncJobsDueRunnable = new AcquireAsyncJobsDueRunnable(this);
        }
        if (this.executeAsyncRunnableFactory == null) {
            this.executeAsyncRunnableFactory = new DefaultExecuteAsyncRunnableFactory();
        }
    }

    @Override
    public synchronized void shutdown() {
        if (!this.isActive) {
            return;
        }
        log.info("Shutting down the default async job executor [{}].", (Object)this.getClass().getName());
        this.timerJobRunnable.stop();
        this.asyncJobsDueRunnable.stop();
        this.stopExecutingAsyncJobs();
        this.timerJobRunnable = null;
        this.asyncJobsDueRunnable = null;
        this.isActive = false;
    }

    protected abstract void startExecutingAsyncJobs();

    protected abstract void stopExecutingAsyncJobs();

    protected void startJobAcquisitionThread() {
        if (this.timerJobAcquisitionThread == null) {
            this.timerJobAcquisitionThread = new Thread(this.timerJobRunnable);
        }
        this.timerJobAcquisitionThread.start();
        if (this.asyncJobAcquisitionThread == null) {
            this.asyncJobAcquisitionThread = new Thread(this.asyncJobsDueRunnable);
        }
        this.asyncJobAcquisitionThread.start();
    }

    protected void stopJobAcquisitionThread() {
        try {
            this.timerJobAcquisitionThread.join();
        }
        catch (InterruptedException e) {
            log.warn("Interrupted while waiting for the timer job acquisition thread to terminate", (Throwable)e);
        }
        try {
            this.asyncJobAcquisitionThread.join();
        }
        catch (InterruptedException e) {
            log.warn("Interrupted while waiting for the async job acquisition thread to terminate", (Throwable)e);
        }
        this.timerJobAcquisitionThread = null;
        this.asyncJobAcquisitionThread = null;
    }

    @Override
    public CommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    @Override
    public void setCommandExecutor(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    @Override
    public boolean isAutoActivate() {
        return this.isAutoActivate;
    }

    @Override
    public void setAutoActivate(boolean isAutoActivate) {
        this.isAutoActivate = isAutoActivate;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    @Override
    public String getLockOwner() {
        return this.lockOwner;
    }

    public void setLockOwner(String lockOwner) {
        this.lockOwner = lockOwner;
    }

    @Override
    public int getTimerLockTimeInMillis() {
        return this.timerLockTimeInMillis;
    }

    @Override
    public void setTimerLockTimeInMillis(int timerLockTimeInMillis) {
        this.timerLockTimeInMillis = timerLockTimeInMillis;
    }

    @Override
    public int getAsyncJobLockTimeInMillis() {
        return this.asyncJobLockTimeInMillis;
    }

    @Override
    public void setAsyncJobLockTimeInMillis(int asyncJobLockTimeInMillis) {
        this.asyncJobLockTimeInMillis = asyncJobLockTimeInMillis;
    }

    @Override
    public int getMaxTimerJobsPerAcquisition() {
        return this.maxTimerJobsPerAcquisition;
    }

    @Override
    public void setMaxTimerJobsPerAcquisition(int maxTimerJobsPerAcquisition) {
        this.maxTimerJobsPerAcquisition = maxTimerJobsPerAcquisition;
    }

    @Override
    public int getMaxAsyncJobsDuePerAcquisition() {
        return this.maxAsyncJobsDuePerAcquisition;
    }

    @Override
    public void setMaxAsyncJobsDuePerAcquisition(int maxAsyncJobsDuePerAcquisition) {
        this.maxAsyncJobsDuePerAcquisition = maxAsyncJobsDuePerAcquisition;
    }

    @Override
    public int getDefaultTimerJobAcquireWaitTimeInMillis() {
        return this.defaultTimerJobAcquireWaitTimeInMillis;
    }

    @Override
    public void setDefaultTimerJobAcquireWaitTimeInMillis(int defaultTimerJobAcquireWaitTimeInMillis) {
        this.defaultTimerJobAcquireWaitTimeInMillis = defaultTimerJobAcquireWaitTimeInMillis;
    }

    @Override
    public int getDefaultAsyncJobAcquireWaitTimeInMillis() {
        return this.defaultAsyncJobAcquireWaitTimeInMillis;
    }

    @Override
    public void setDefaultAsyncJobAcquireWaitTimeInMillis(int defaultAsyncJobAcquireWaitTimeInMillis) {
        this.defaultAsyncJobAcquireWaitTimeInMillis = defaultAsyncJobAcquireWaitTimeInMillis;
    }

    @Override
    public int getDefaultQueueSizeFullWaitTimeInMillis() {
        return this.defaultQueueSizeFullWaitTime;
    }

    @Override
    public void setDefaultQueueSizeFullWaitTimeInMillis(int defaultQueueSizeFullWaitTime) {
        this.defaultQueueSizeFullWaitTime = defaultQueueSizeFullWaitTime;
    }

    public void setTimerJobRunnable(AcquireTimerJobsRunnable timerJobRunnable) {
        this.timerJobRunnable = timerJobRunnable;
    }

    public void setAsyncJobsDueRunnable(AcquireAsyncJobsDueRunnable asyncJobsDueRunnable) {
        this.asyncJobsDueRunnable = asyncJobsDueRunnable;
    }

    @Override
    public int getRetryWaitTimeInMillis() {
        return this.retryWaitTimeInMillis;
    }

    @Override
    public void setRetryWaitTimeInMillis(int retryWaitTimeInMillis) {
        this.retryWaitTimeInMillis = retryWaitTimeInMillis;
    }

    public ExecuteAsyncRunnableFactory getExecuteAsyncRunnableFactory() {
        return this.executeAsyncRunnableFactory;
    }

    public void setExecuteAsyncRunnableFactory(ExecuteAsyncRunnableFactory executeAsyncRunnableFactory) {
        this.executeAsyncRunnableFactory = executeAsyncRunnableFactory;
    }
}

