/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.task.IdentityLink;

public class GetIdentityLinksForProcessInstanceCmd
implements Command<List<IdentityLink>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processInstanceId;

    public GetIdentityLinksForProcessInstanceCmd(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public List<IdentityLink> execute(CommandContext commandContext) {
        ExecutionEntity processInstance = commandContext.getExecutionEntityManager().findExecutionById(this.processInstanceId);
        if (processInstance == null) {
            throw new ActivitiObjectNotFoundException("Cannot find process definition with id " + this.processInstanceId, ExecutionEntity.class);
        }
        return processInstance.getIdentityLinks();
    }
}

