/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.variable;

import org.activiti.engine.impl.variable.ValueFields;
import org.activiti.engine.impl.variable.VariableType;

public class ShortType
implements VariableType {
    private static final long serialVersionUID = 1L;

    @Override
    public String getTypeName() {
        return "short";
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public Object getValue(ValueFields valueFields) {
        if (valueFields.getLongValue() != null) {
            return new Short(valueFields.getLongValue().shortValue());
        }
        return null;
    }

    @Override
    public void setValue(Object value, ValueFields valueFields) {
        if (value != null) {
            valueFields.setLongValue(((Short)value).longValue());
            valueFields.setTextValue(value.toString());
        } else {
            valueFields.setLongValue(null);
            valueFields.setTextValue(null);
        }
    }

    @Override
    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        return Short.class.isAssignableFrom(value.getClass()) || Short.TYPE.isAssignableFrom(value.getClass());
    }
}

