/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.explorer.ui.management.admin;

import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.ui.Component;
import com.vaadin.ui.Table;
import org.activiti.explorer.ExplorerApp;
import org.activiti.explorer.I18nManager;
import org.activiti.explorer.navigation.UriFragment;
import org.activiti.explorer.ui.management.ManagementPage;
import org.activiti.explorer.ui.management.admin.AdminCompletedInstancesPanel;
import org.activiti.explorer.ui.management.admin.AdminDatabaseSettingsPanel;
import org.activiti.explorer.ui.management.admin.AdminRunningInstancesPanel;

public class AdministrationPage
extends ManagementPage {
    private static final long serialVersionUID = 1L;
    protected I18nManager i18nManager;
    protected String managementId;
    protected Table managementTable;

    public AdministrationPage() {
        ExplorerApp.get().setCurrentUriFragment(new UriFragment("admin_management"));
        this.i18nManager = ExplorerApp.get().getI18nManager();
    }

    public AdministrationPage(String managementId) {
        this.managementId = managementId;
    }

    @Override
    protected void initUi() {
        super.initUi();
        int index = 0;
        if (this.managementId != null) {
            index = Integer.valueOf(this.managementId);
        }
        this.managementTable.select((Object)index);
        this.managementTable.setCurrentPageFirstItemId((Object)index);
    }

    @Override
    protected Table createList() {
        this.managementTable = new Table();
        this.managementTable.setEditable(false);
        this.managementTable.setImmediate(true);
        this.managementTable.setSelectable(true);
        this.managementTable.setNullSelectionAllowed(false);
        this.managementTable.setSortDisabled(true);
        this.managementTable.setSizeFull();
        this.managementTable.addContainerProperty((Object)"name", String.class, null);
        this.managementTable.setColumnHeaderMode(-1);
        this.managementTable.addItem((Object[])new String[]{this.i18nManager.getMessage("admin.menu.running")}, (Object)0);
        this.managementTable.addItem((Object[])new String[]{this.i18nManager.getMessage("admin.menu.completed")}, (Object)1);
        this.managementTable.addItem((Object[])new String[]{this.i18nManager.getMessage("admin.menu.database")}, (Object)2);
        this.managementTable.addListener(new Property.ValueChangeListener(){
            private static final long serialVersionUID = 1L;

            public void valueChange(Property.ValueChangeEvent event) {
                Item item = AdministrationPage.this.managementTable.getItem(event.getProperty().getValue());
                if (item != null) {
                    if ("0".equals(event.getProperty().getValue().toString())) {
                        AdministrationPage.this.setDetailComponent((Component)new AdminRunningInstancesPanel());
                    } else if ("1".equals(event.getProperty().getValue().toString())) {
                        AdministrationPage.this.setDetailComponent((Component)new AdminCompletedInstancesPanel());
                    } else if ("2".equals(event.getProperty().getValue().toString())) {
                        AdministrationPage.this.setDetailComponent((Component)new AdminDatabaseSettingsPanel());
                    }
                    ExplorerApp.get().setCurrentUriFragment(new UriFragment("admin_management", event.getProperty().getValue().toString()));
                } else {
                    AdministrationPage.this.setDetailComponent(null);
                    ExplorerApp.get().setCurrentUriFragment(new UriFragment("admin_management", AdministrationPage.this.managementId));
                }
            }
        });
        return this.managementTable;
    }

    public void notifyGroupChanged(String managementId) {
        this.managementTable.removeAllItems();
        this.managementTable.select((Object)Integer.valueOf(managementId));
    }
}

