/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.management.jmx;

import javax.management.JMException;
import javax.management.ObjectName;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.RequiredModelMBean;
import org.activiti.management.jmx.MBeanInfoAssembler;
import org.activiti.management.jmx.ManagementMBeanAssembler;
import org.activiti.management.jmx.NotificationSenderAdapter;
import org.activiti.management.jmx.annotations.NotificationSenderAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultManagementMBeanAssembler
implements ManagementMBeanAssembler {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultManagementMBeanAssembler.class);
    protected final MBeanInfoAssembler assembler = new MBeanInfoAssembler();

    @Override
    public ModelMBean assemble(Object obj, ObjectName name) throws JMException {
        ModelMBeanInfo mbi = null;
        LOG.trace("Assembling MBeanInfo for: {} from @ManagedResource object: {}", (Object)name, obj);
        mbi = this.assembler.getMBeanInfo(obj, null, name.toString());
        if (mbi == null) {
            return null;
        }
        RequiredModelMBean mbean = new RequiredModelMBean(mbi);
        try {
            mbean.setManagedResource(obj, "ObjectReference");
        }
        catch (InvalidTargetObjectTypeException e) {
            throw new JMException(e.getMessage());
        }
        if (obj instanceof NotificationSenderAware) {
            ((NotificationSenderAware)obj).setNotificationSender(new NotificationSenderAdapter(mbean));
        }
        return mbean;
    }
}

