/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.management.jmx.mbeans;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.activiti.engine.ProcessEngineConfiguration;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.DeploymentBuilder;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.management.jmx.annotations.ManagedAttribute;
import org.activiti.management.jmx.annotations.ManagedOperation;
import org.activiti.management.jmx.annotations.ManagedResource;

@ManagedResource(description="Process definition MBean")
public class ProcessDefinitionsMBean {
    RepositoryService repositoryService;

    public ProcessDefinitionsMBean(ProcessEngineConfiguration processEngineConfig) {
        if (processEngineConfig != null) {
            this.repositoryService = processEngineConfig.getRepositoryService();
        }
    }

    @ManagedAttribute(description="List of Process definitions")
    public List<List<String>> getProcessDefinitions() {
        List deployments = this.repositoryService.createProcessDefinitionQuery().list();
        ArrayList<List<String>> result = new ArrayList<List<String>>(deployments.size());
        for (ProcessDefinition deployment : deployments) {
            ArrayList<String> item = new ArrayList<String>(3);
            item.add(deployment.getId());
            item.add(deployment.getName());
            item.add(Integer.toString(deployment.getVersion()));
            item.add(Boolean.toString(deployment.isSuspended()));
            item.add(deployment.getDescription());
            result.add(item);
        }
        return result;
    }

    @ManagedOperation(description="get a specific process definition")
    public List<String> getProcessDefinitionById(String id) {
        ProcessDefinition pd = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(id).singleResult();
        ArrayList<String> item = new ArrayList<String>(3);
        item.add(pd.getId());
        item.add(pd.getName());
        item.add(Integer.toString(pd.getVersion()));
        item.add(Boolean.toString(pd.isSuspended()));
        item.add(pd.getDescription());
        return item;
    }

    @ManagedAttribute(description="List of deployed Processes")
    public List<List<String>> getDeployments() {
        List deployments = this.repositoryService.createDeploymentQuery().list();
        ArrayList<List<String>> result = new ArrayList<List<String>>(deployments.size());
        for (Deployment deployment : deployments) {
            ArrayList<String> item = new ArrayList<String>(3);
            item.add(deployment.getId());
            item.add(deployment.getName());
            item.add(deployment.getTenantId());
            result.add(item);
        }
        return result;
    }

    @ManagedOperation(description="delete deployment")
    public void deleteDeployment(String deploymentId) {
        this.repositoryService.deleteDeployment(deploymentId);
    }

    @ManagedOperation(description="Suspend given process ID")
    public void suspendProcessDefinitionById(String processId) {
        this.repositoryService.suspendProcessDefinitionById(processId);
    }

    @ManagedOperation(description="Activate given process ID")
    public void activatedProcessDefinitionById(String processId) {
        this.repositoryService.activateProcessDefinitionById(processId);
    }

    @ManagedOperation(description="Suspend given process ID")
    public void suspendProcessDefinitionByKey(String processDefinitionKey) {
        this.repositoryService.suspendProcessDefinitionByKey(processDefinitionKey);
    }

    @ManagedOperation(description="Activate given process ID")
    public void activatedProcessDefinitionByKey(String processDefinitionKey) {
        this.repositoryService.activateProcessDefinitionByKey(processDefinitionKey);
    }

    @ManagedOperation(description="Deploy Process Definition")
    public void deployProcessDefinition(String resourceName, String processDefinitionFile) throws FileNotFoundException {
        DeploymentBuilder deploymentBuilder = this.repositoryService.createDeployment();
        Deployment deployment = deploymentBuilder.addInputStream(resourceName, (InputStream)new FileInputStream(processDefinitionFile)).deploy();
    }
}

