/* Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.activiti.rest.service.api.runtime.task;

import java.util.ArrayList;
import java.util.List;

import org.activiti.engine.task.Task;
import org.activiti.rest.common.api.ActivitiUtil;
import org.activiti.rest.service.api.RestResponseFactory;
import org.activiti.rest.service.application.ActivitiRestServicesApplication;
import org.restlet.resource.Get;


/**
 * @author Tijs Rademakers
 */
public class TaskSubTaskCollectionResource extends TaskBaseResource {

  @Get
  public List<TaskResponse> getSubTasks() {
    if(!authenticate())
      return null;
    
    List<TaskResponse> result = new ArrayList<TaskResponse>();
    RestResponseFactory responseFactory = getApplication(ActivitiRestServicesApplication.class).getRestResponseFactory();
    Task task = getTaskFromRequest();
    
    for(Task taskObject : ActivitiUtil.getTaskService().getSubTasks(task.getId())) {
      result.add(responseFactory.createTaskResponse(this, taskObject));
    }
    
    return result;
  }
}
