/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.gradle.git.auth;

import org.eclipse.jgit.awtui.AwtCredentialsProvider;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.gradle.api.artifacts.repositories.AuthenticationSupported;
import org.gradle.api.artifacts.repositories.PasswordCredentials;

public class JGitCredentialsProviderSupport {
    private final AuthenticationSupported authSupport;

    public JGitCredentialsProviderSupport(AuthenticationSupported authSupport) {
        this.authSupport = authSupport;
    }

    public CredentialsProvider getCredentialsProvider() {
        PasswordCredentials creds = this.authSupport.getCredentials();
        if (creds != null && creds.getUsername() != null && creds.getPassword() != null) {
            return new UsernamePasswordCredentialsProvider(creds.getUsername(), creds.getPassword());
        }
        return new AwtCredentialsProvider();
    }
}

