/*
 * Decompiled with CFR 0.152.
 */
package org.amqphub.spring.boot.jms.autoconfigure;

import java.util.List;
import javax.jms.ConnectionFactory;
import org.amqphub.spring.boot.jms.autoconfigure.AMQP10JMSConnectionFactoryCustomizer;
import org.amqphub.spring.boot.jms.autoconfigure.AMQP10JMSConnectionFactoryFactory;
import org.amqphub.spring.boot.jms.autoconfigure.AMQP10JMSProperties;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.messaginghub.pooled.jms.JmsPoolConnectionFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jms.JmsAutoConfiguration;
import org.springframework.boot.autoconfigure.jms.JndiConnectionFactoryAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureBefore(value={JmsAutoConfiguration.class})
@AutoConfigureAfter(value={JndiConnectionFactoryAutoConfiguration.class})
@ConditionalOnMissingBean(value={ConnectionFactory.class})
@ConditionalOnClass(value={ConnectionFactory.class, JmsConnectionFactory.class})
@EnableConfigurationProperties(value={AMQP10JMSProperties.class})
public class AMQP10JMSAutoConfiguration {
    @Bean
    @ConditionalOnProperty(prefix="amqphub.amqp10jms.pool", name={"enabled"}, havingValue="false", matchIfMissing=true)
    public JmsConnectionFactory jmsConnectionFactory(AMQP10JMSProperties properties, ObjectProvider<List<AMQP10JMSConnectionFactoryCustomizer>> factoryCustomizers) {
        return new AMQP10JMSConnectionFactoryFactory(properties, (List)factoryCustomizers.getIfAvailable()).createConnectionFactory(JmsConnectionFactory.class);
    }

    @Configuration
    @ConditionalOnClass(value={JmsPoolConnectionFactory.class})
    static class PooledConnectionFactoryConfiguration {
        PooledConnectionFactoryConfiguration() {
        }

        @Bean(destroyMethod="stop")
        @ConditionalOnProperty(prefix="amqphub.amqp10jms.pool", name={"enabled"}, havingValue="true", matchIfMissing=false)
        public JmsPoolConnectionFactory pooledJmsConnectionFactory(AMQP10JMSProperties properties, ObjectProvider<List<AMQP10JMSConnectionFactoryCustomizer>> factoryCustomizers) {
            JmsPoolConnectionFactory pooledConnectionFactory = new JmsPoolConnectionFactory();
            pooledConnectionFactory.setConnectionFactory((Object)new AMQP10JMSConnectionFactoryFactory(properties, (List)factoryCustomizers.getIfAvailable()).createConnectionFactory(JmsConnectionFactory.class));
            AMQP10JMSProperties.Pool pool = properties.getPool();
            pool.configurePooledFactory(pooledConnectionFactory);
            return pooledConnectionFactory;
        }
    }
}

