/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.mojo.antlr4;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.mojo.antlr4.MojoUtils;
import org.antlr.runtime.tree.Tree;
import org.antlr.v4.Tool;
import org.antlr.v4.misc.Graph;
import org.antlr.v4.tool.ast.GrammarAST;
import org.antlr.v4.tool.ast.GrammarRootAST;
import org.apache.maven.plugin.logging.Log;

class GrammarDependencies {
    private final Graph<String> graph = new Graph();
    private final File sourceDirectory;
    private final File libDirectory;
    private final File statusFile;
    private final String packageName;
    private final Map<File, Map.Entry<byte[], Collection<String>>> grammars;
    private final Log log;

    public GrammarDependencies(File sourceDirectory, File libDirectory, List<String> arguments, File status, Log log) {
        this.log = log;
        this.sourceDirectory = sourceDirectory;
        this.libDirectory = libDirectory;
        this.statusFile = status;
        this.grammars = this.loadStatus(status);
        this.packageName = this.getPackage(arguments);
    }

    private String getPackage(List<String> arguments) {
        int index = arguments != null ? arguments.indexOf("-package") : -1;
        return index > -1 ? arguments.get(index + 1).replace('.', File.separatorChar) + File.separatorChar : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        if (!this.grammars.isEmpty()) {
            this.log.debug((CharSequence)("Persisting grammars dependency status: " + this.statusFile));
            try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(this.statusFile));){
                out.writeObject(this.grammars);
            }
        }
    }

    public GrammarDependencies analyze(Set<File> grammarFiles, Set<File> importGrammarFiles, Tool tool) throws IOException {
        Collection<String> usages;
        this.log.debug((CharSequence)("Analysing grammar dependencies " + this.sourceDirectory));
        HashSet<File> grammarsAndTokens = new HashSet<File>();
        grammarsAndTokens.addAll(importGrammarFiles);
        grammarsAndTokens.addAll(grammarFiles);
        for (File grammarFile : grammarsAndTokens) {
            if (grammarFile.getName().endsWith(".tokens")) continue;
            this.analyse(grammarFile, grammarsAndTokens, tool);
        }
        for (File grammarFile : grammarFiles) {
            usages = this.findUsages(this.getRelativePath(grammarFile));
            if (usages.isEmpty()) continue;
            this.grammars.put(grammarFile, new AbstractMap.SimpleImmutableEntry<byte[], Collection<String>>(MojoUtils.checksum(grammarFile), usages));
            this.log.debug((CharSequence)("  " + this.getRelativePath(grammarFile) + " used by " + usages));
        }
        for (File grammarFile : importGrammarFiles) {
            usages = this.findUsages(grammarFile.getName());
            if (usages.isEmpty()) continue;
            this.grammars.put(grammarFile, new AbstractMap.SimpleImmutableEntry<byte[], Collection<String>>(MojoUtils.checksum(grammarFile), usages));
            this.log.debug((CharSequence)("  " + grammarFile.getName() + " imported by " + usages));
        }
        return this;
    }

    public boolean isDependencyChanged(File grammarFile) throws IOException {
        String grammarPath = this.getRelativePath(grammarFile);
        for (Map.Entry<File, Map.Entry<byte[], Collection<String>>> e : this.grammars.entrySet()) {
            File depGrammarFile = e.getKey();
            byte[] checksum = e.getValue().getKey();
            Collection<String> usages = e.getValue().getValue();
            if (!usages.contains(grammarPath) || depGrammarFile.exists() && Arrays.equals(MojoUtils.checksum(depGrammarFile), checksum)) continue;
            this.log.debug((CharSequence)("  " + grammarPath + ": dependency " + depGrammarFile.getName() + " changed"));
            return true;
        }
        return false;
    }

    private String getRelativePath(File grammarFile) {
        if (grammarFile.getPath().startsWith(this.libDirectory.getPath())) {
            return grammarFile.getName();
        }
        if (this.packageName != null) {
            return this.packageName + grammarFile.getName();
        }
        String path = MojoUtils.findSourceSubdir(this.sourceDirectory, grammarFile);
        return path + grammarFile.getName();
    }

    private Collection<String> findUsages(String grammarFileName) {
        ArrayList<String> result = new ArrayList<String>();
        this.explore(grammarFileName, result);
        return result;
    }

    private void explore(String grammarName, Collection<String> result) {
        for (Graph.Node node : this.graph.getNode((Object)grammarName).edges) {
            result.add((String)node.payload);
            this.explore((String)node.payload, result);
        }
    }

    private void analyse(File grammarFile, Collection<File> grammarFiles, Tool tool) {
        GrammarRootAST grammar = tool.parseGrammar(grammarFile.getAbsolutePath());
        if (grammar == null) {
            return;
        }
        for (GrammarAST importDecl : grammar.getAllChildrenWithType(29)) {
            for (Tree id : importDecl.getAllChildrenWithType(28)) {
                if (id == null) continue;
                String grammarPath = this.getRelativePath(grammarFile);
                this.graph.addEdge((Object)(id.getText() + ".g4"), (Object)grammarPath);
            }
        }
        for (GrammarAST options : grammar.getAllChildrenWithType(42)) {
            int count = options.getChildCount();
            for (int i = 0; i < count; ++i) {
                Tree option = options.getChild(i);
                if (option.getType() != 10) continue;
                String key = option.getChild(0).getText();
                String value = option.getChild(1).getText();
                if (!"tokenVocab".equals(key)) continue;
                String name = this.stripQuotes(value);
                String grammarName = this.stripPath(name);
                String grammarPath = MojoUtils.findSourceSubdir(this.sourceDirectory, grammarFile);
                File depGrammarFile = this.resolve(grammarName, grammarPath);
                if (this.packageName != null) {
                    grammarPath = this.packageName;
                }
                this.graph.addEdge((Object)this.getRelativePath(depGrammarFile), (Object)(grammarPath + grammarFile.getName()));
            }
        }
    }

    private File resolve(String name, String path) {
        File file = new File(this.sourceDirectory, path + name + ".g4");
        if (file.exists()) {
            return file;
        }
        file = new File(this.libDirectory, name + ".g4");
        if (file.exists()) {
            return file;
        }
        return new File(this.libDirectory, name + ".tokens");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<File, Map.Entry<byte[], Collection<String>>> loadStatus(File statusFile) {
        if (statusFile.exists()) {
            Map map;
            this.log.debug((CharSequence)("Load grammars dependency status: " + statusFile));
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(statusFile));
            try {
                Map data;
                map = data = (Map)in.readObject();
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                    throw throwable;
                }
                catch (Exception ex) {
                    this.log.warn((CharSequence)"Could not load grammar dependency status information", (Throwable)ex);
                }
            }
            in.close();
            return map;
        }
        return new HashMap<File, Map.Entry<byte[], Collection<String>>>();
    }

    private String stripPath(String str) {
        return str.replaceAll("^.*[/\\\\]", "");
    }

    private String stripQuotes(String str) {
        return str.replaceAll("\\A'|'\\Z", "");
    }
}

