/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.Collection;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.CamelOpenMBeanTypes;
import org.apache.camel.api.management.mbean.ManagedValidatorRegistryMBean;
import org.apache.camel.management.mbean.ManagedService;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.Validator;
import org.apache.camel.spi.ValidatorRegistry;
import org.apache.camel.util.ObjectHelper;

@ManagedResource(description="Managed ValidatorRegistry")
public class ManagedValidatorRegistry
extends ManagedService
implements ManagedValidatorRegistryMBean {
    private final ValidatorRegistry validatorRegistry;

    public ManagedValidatorRegistry(CamelContext context, ValidatorRegistry validatorRegistry) {
        super(context, validatorRegistry);
        this.validatorRegistry = validatorRegistry;
    }

    @Override
    public void init(ManagementStrategy strategy) {
        super.init(strategy);
    }

    public ValidatorRegistry getValidatorRegistry() {
        return this.validatorRegistry;
    }

    @Override
    public String getSource() {
        return this.validatorRegistry.toString();
    }

    @Override
    public Integer getDynamicSize() {
        return this.validatorRegistry.dynamicSize();
    }

    @Override
    public Integer getStaticSize() {
        return this.validatorRegistry.staticSize();
    }

    @Override
    public Integer getSize() {
        return this.validatorRegistry.size();
    }

    @Override
    public Integer getMaximumCacheSize() {
        return this.validatorRegistry.getMaximumCacheSize();
    }

    @Override
    public void purge() {
        this.validatorRegistry.purge();
    }

    @Override
    public TabularData listValidators() {
        try {
            TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.listValidatorsTabularType());
            Collection validators = this.validatorRegistry.values();
            for (Validator validator : validators) {
                CompositeType ct = CamelOpenMBeanTypes.listValidatorsCompositeType();
                DataType type = validator.getType();
                String desc = validator.toString();
                boolean isStatic = this.validatorRegistry.isStatic(type);
                boolean isDynamic = this.validatorRegistry.isDynamic(type);
                CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"type", "static", "dynamic", "description"}, new Object[]{type.toString(), isStatic, isDynamic, desc});
                answer.put(data);
            }
            return answer;
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }
}

