/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.camel;

import org.apache.activemq.broker.BrokerService;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public final class CamelShutdownHook
implements Runnable,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(CamelShutdownHook.class);
    private CamelContext camelContext;

    @Autowired
    public CamelShutdownHook(BrokerService brokerService) {
        brokerService.addPreShutdownHook(this);
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void run() {
        if (this.camelContext != null) {
            try {
                this.camelContext.stop();
            }
            catch (Exception e) {
                LOG.warn("Unable to stop CamelContext", e);
            }
        } else {
            LOG.warn("Unable to stop CamelContext, no CamelContext was set!");
        }
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }
}

