/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.validator;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.validator.DefaultValidatorResourceResolverFactory;
import org.apache.camel.component.validator.ValidatorEndpoint;
import org.apache.camel.component.validator.ValidatorResourceResolverFactory;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.spi.Metadata;

public class ValidatorComponent
extends UriEndpointComponent {
    @Metadata(label="advanced", description="To use a custom LSResourceResolver which depends on a dynamic endpoint resource URI")
    private ValidatorResourceResolverFactory resourceResolverFactory;

    public ValidatorComponent() {
        this(ValidatorEndpoint.class);
    }

    public ValidatorComponent(Class<? extends Endpoint> endpointClass) {
        super(endpointClass);
    }

    public ValidatorResourceResolverFactory getResourceResolverFactory() {
        return this.resourceResolverFactory;
    }

    public void setResourceResolverFactory(ValidatorResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        ValidatorEndpoint endpoint = new ValidatorEndpoint(uri, this, remaining);
        ValidatorResourceResolverFactory resolverFactory = this.resolveAndRemoveReferenceParameter(parameters, "resourceResolverFactory", ValidatorResourceResolverFactory.class);
        if (resolverFactory == null) {
            resolverFactory = this.getResourceResolverFactory();
        }
        if (resolverFactory == null) {
            resolverFactory = new DefaultValidatorResourceResolverFactory();
        }
        endpoint.setResourceResolverFactory(resolverFactory);
        this.setProperties(endpoint, parameters);
        return endpoint;
    }
}

