/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.util.ObjectHelper;
import org.w3c.dom.NodeList;

public final class CollectionHelper {
    private CollectionHelper() {
    }

    public static Integer size(Object value) {
        if (value != null) {
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                return collection.size();
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                return map.size();
            }
            if (value instanceof Object[]) {
                Object[] array = (Object[])value;
                return array.length;
            }
            if (value.getClass().isArray()) {
                return Array.getLength(value);
            }
            if (value instanceof NodeList) {
                NodeList nodeList = (NodeList)value;
                return nodeList.getLength();
            }
        }
        return null;
    }

    public static void appendValue(Map<String, Object> map, String key, Object value) {
        Object oldValue = map.get(key);
        if (oldValue != null) {
            ArrayList<Object> list;
            if (oldValue instanceof List) {
                list = (ArrayList<Object>)oldValue;
            } else {
                list = new ArrayList<Object>();
                list.add(oldValue);
                map.remove(key);
                map.put(key, list);
            }
            list.add(value);
        } else {
            map.put(key, value);
        }
    }

    public static <T> Set<T> createSetContaining(T ... contents) {
        HashSet<T> contentsAsSet = new HashSet<T>();
        contentsAsSet.addAll(Arrays.asList(contents));
        return contentsAsSet;
    }

    public static String collectionAsCommaDelimitedString(String[] col) {
        if (col == null || col.length == 0) {
            return "";
        }
        return CollectionHelper.collectionAsCommaDelimitedString(Arrays.asList(col));
    }

    public static String collectionAsCommaDelimitedString(Collection<?> col) {
        if (col == null || col.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<?> it = col.iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString());
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public static Map<String, Object> flatternKeysInMap(Map<String, Object> map, String separator) {
        LinkedHashMap<String, Object> answer = new LinkedHashMap<String, Object>();
        CollectionHelper.doFlatternKeysInMap(map, "", ObjectHelper.isNotEmpty(separator) ? separator : "", answer);
        return answer;
    }

    private static void doFlatternKeysInMap(Map<String, Object> source, String prefix, String separator, Map<String, Object> target) {
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            String newKey;
            String key = entry.getKey();
            Object value = entry.getValue();
            String string = newKey = prefix.isEmpty() ? key : prefix + separator + key;
            if (value instanceof Map) {
                Map map = (Map)value;
                CollectionHelper.doFlatternKeysInMap(map, newKey, separator, target);
                continue;
            }
            target.put(newKey, value);
        }
    }
}

