/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.policy;

import org.apache.activemq.broker.region.DurableTopicSubscription;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.policy.AbstractDeadLetterStrategy;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.Message;

public class IndividualDeadLetterStrategy
extends AbstractDeadLetterStrategy {
    private String topicPrefix = "ActiveMQ.DLQ.Topic.";
    private String queuePrefix = "ActiveMQ.DLQ.Queue.";
    private boolean useQueueForQueueMessages = true;
    private boolean useQueueForTopicMessages = true;
    private boolean destinationPerDurableSubscriber;

    @Override
    public ActiveMQDestination getDeadLetterQueueFor(Message message, Subscription subscription) {
        if (message.getDestination().isQueue()) {
            return this.createDestination(message, this.queuePrefix, this.useQueueForQueueMessages, subscription);
        }
        return this.createDestination(message, this.topicPrefix, this.useQueueForTopicMessages, subscription);
    }

    public String getQueuePrefix() {
        return this.queuePrefix;
    }

    public void setQueuePrefix(String queuePrefix) {
        this.queuePrefix = queuePrefix;
    }

    public String getTopicPrefix() {
        return this.topicPrefix;
    }

    public void setTopicPrefix(String topicPrefix) {
        this.topicPrefix = topicPrefix;
    }

    public boolean isUseQueueForQueueMessages() {
        return this.useQueueForQueueMessages;
    }

    public void setUseQueueForQueueMessages(boolean useQueueForQueueMessages) {
        this.useQueueForQueueMessages = useQueueForQueueMessages;
    }

    public boolean isUseQueueForTopicMessages() {
        return this.useQueueForTopicMessages;
    }

    public void setUseQueueForTopicMessages(boolean useQueueForTopicMessages) {
        this.useQueueForTopicMessages = useQueueForTopicMessages;
    }

    public boolean isDestinationPerDurableSubscriber() {
        return this.destinationPerDurableSubscriber;
    }

    public void setDestinationPerDurableSubscriber(boolean destinationPerDurableSubscriber) {
        this.destinationPerDurableSubscriber = destinationPerDurableSubscriber;
    }

    protected ActiveMQDestination createDestination(Message message, String prefix, boolean useQueue, Subscription subscription) {
        String name = prefix + message.getDestination().getPhysicalName();
        if (this.destinationPerDurableSubscriber && subscription instanceof DurableTopicSubscription) {
            name = name + "." + ((DurableTopicSubscription)subscription).getSubscriptionKey();
        }
        if (useQueue) {
            return new ActiveMQQueue(name);
        }
        return new ActiveMQTopic(name);
    }
}

