/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.index.hash;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.activemq.kaha.Marshaller;

class HashEntry
implements Comparable {
    static final int NOT_SET = -1;
    private Comparable key;
    private long indexOffset;

    HashEntry() {
    }

    public int compareTo(Object o) {
        if (o instanceof HashEntry) {
            HashEntry other = (HashEntry)o;
            return this.key.compareTo(other.key);
        }
        return this.key.compareTo(o);
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return "HashEntry(" + this.key + "," + this.indexOffset + ")";
    }

    HashEntry copy() {
        HashEntry copy = new HashEntry();
        copy.key = this.key;
        copy.indexOffset = this.indexOffset;
        return copy;
    }

    Comparable getKey() {
        return this.key;
    }

    void setKey(Comparable key) {
        this.key = key;
    }

    long getIndexOffset() {
        return this.indexOffset;
    }

    void setIndexOffset(long indexOffset) {
        this.indexOffset = indexOffset;
    }

    void write(Marshaller keyMarshaller, DataOutput dataOut) throws IOException {
        dataOut.writeLong(this.indexOffset);
        keyMarshaller.writePayload(this.key, dataOut);
    }

    void read(Marshaller keyMarshaller, DataInput dataIn) throws IOException {
        this.indexOffset = dataIn.readLong();
        this.key = (Comparable)keyMarshaller.readPayload(dataIn);
    }
}

