/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usage;

import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.usage.Usage;

public class StoreUsage
extends Usage<StoreUsage> {
    private PersistenceAdapter store;

    public StoreUsage() {
        super(null, null, 1.0f);
    }

    public StoreUsage(String name, PersistenceAdapter store) {
        super(null, name, 1.0f);
        this.store = store;
    }

    public StoreUsage(StoreUsage parent, String name) {
        super((Usage)parent, name, 1.0f);
        this.store = parent.store;
    }

    protected long retrieveUsage() {
        if (this.store == null) {
            return 0L;
        }
        return this.store.size();
    }

    public PersistenceAdapter getStore() {
        return this.store;
    }

    public void setStore(PersistenceAdapter store) {
        this.store = store;
        this.onLimitChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPercentUsage() {
        this.usageLock.writeLock().lock();
        try {
            this.percentUsage = this.caclPercentUsage();
            int n = super.getPercentUsage();
            return n;
        }
        finally {
            this.usageLock.writeLock().unlock();
        }
    }

    public boolean waitForSpace(long timeout, int highWaterMark) throws InterruptedException {
        if (this.parent != null && ((StoreUsage)this.parent).waitForSpace(timeout, highWaterMark)) {
            return true;
        }
        return super.waitForSpace(timeout, highWaterMark);
    }
}

