/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.pool;

import java.io.IOException;
import javax.jms.Connection;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.jms.pool.ConnectionPool;
import org.apache.activemq.jms.pool.JcaConnectionPool;
import org.apache.activemq.pool.XaPooledConnectionFactory;
import org.apache.activemq.transport.TransportListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcaPooledConnectionFactory
extends XaPooledConnectionFactory {
    private static final transient Logger LOG = LoggerFactory.getLogger(JcaPooledConnectionFactory.class);
    private String name;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    protected ConnectionPool createConnectionPool(Connection connection) {
        return new JcaConnectionPool(connection, this.getTransactionManager(), this.getName()){

            protected Connection wrap(final Connection connection) {
                ((ActiveMQConnection)connection).addTransportListener(new TransportListener(){

                    public void onCommand(Object command) {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onException(IOException error) {
                        1 var2_2 = this;
                        synchronized (var2_2) {
                            this.setHasExpired(true);
                            LOG.info("Expiring connection " + connection + " on IOException: " + error);
                            LOG.debug("Expiring connection on IOException", (Throwable)error);
                        }
                    }

                    public void transportInterupted() {
                    }

                    public void transportResumed() {
                    }
                });
                this.setHasExpired(((ActiveMQConnection)connection).isTransportFailed());
                return connection;
            }

            protected void unWrap(Connection connection) {
                if (connection != null) {
                    ((ActiveMQConnection)connection).cleanUpTempDestinations();
                }
            }
        };
    }
}

