/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.util.concurrent.TimeUnit;
import javax.management.JMException;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.ManagementContext;
import org.apache.activemq.util.DefaultTestAppender;
import org.apache.activemq.util.Wait;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TcpTransportCloseConnectionTest {
    static boolean transportConnectionFailed = false;
    private BrokerService broker;
    private final String uri = "tcp://localhost:0?wireFormat.maxInactivityDuration=500";
    static final Appender appender = new DefaultTestAppender(){

        public void doAppend(LoggingEvent event) {
            if (event.getMessage().toString().contains("Transport Connection") && event.getMessage().toString().contains("failed") && (event.getMessage().toString().contains("java.net.SocketException") || event.getMessage().toString().contains("java.io.EOFException"))) {
                transportConnectionFailed = true;
            }
        }
    };

    @BeforeClass
    public static void setUp() throws Exception {
        Logger.getRootLogger().addAppender(appender);
    }

    @AfterClass
    public static void setDown() throws Exception {
        Logger.getRootLogger().removeAppender(appender);
    }

    @Before
    public void startBroker() throws Exception {
        this.broker = new BrokerService();
        this.broker.setPersistent(false);
        this.broker.addConnector("tcp://localhost:0?wireFormat.maxInactivityDuration=500");
        CustomManagementContext customManagementContext = new CustomManagementContext();
        this.broker.setManagementContext((ManagementContext)customManagementContext);
        this.broker.start();
    }

    @After
    public void tearDown() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
            this.broker.waitUntilStopped();
        }
    }

    @Test
    public void tesCloseConnectionTest() throws Exception {
        ActiveMQConnectionFactory activeMQConnectionFactory = new ActiveMQConnectionFactory(this.broker.getDefaultSocketURIString());
        activeMQConnectionFactory.setWatchTopicAdvisories(false);
        ActiveMQConnection connection = (ActiveMQConnection)activeMQConnectionFactory.createConnection();
        connection.start();
        connection.close();
        Assert.assertFalse((String)"The Transport has not failed", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return transportConnectionFailed;
            }
        }, (long)2000L));
    }

    class CustomManagementContext
    extends ManagementContext {
        CustomManagementContext() {
        }

        public void unregisterMBean(ObjectName name) throws JMException {
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            super.unregisterMBean(name);
        }
    }
}

