/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import java.io.File;
import java.util.List;
import javax.jms.Message;
import junit.framework.TestCase;
import org.apache.activemq.spring.SpringConsumer;
import org.apache.activemq.spring.SpringProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringTest
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(SpringTest.class);
    protected AbstractApplicationContext context;
    protected SpringConsumer consumer;
    protected SpringProducer producer;

    public void testSenderWithSpringXml() throws Exception {
        this.assertSenderConfig("org/apache/activemq/broker/spring.xml");
    }

    protected void assertSenderConfig(String config) throws Exception {
        this.context = new ClassPathXmlApplicationContext(config);
        this.consumer = (SpringConsumer)((Object)this.context.getBean("consumer"));
        SpringTest.assertTrue((String)"Found a valid consumer", (this.consumer != null ? 1 : 0) != 0);
        this.consumer.start();
        this.producer = (SpringProducer)this.context.getBean("producer");
        SpringTest.assertTrue((String)"Found a valid producer", (this.producer != null ? 1 : 0) != 0);
        this.consumer.flushMessages();
        this.producer.start();
        this.consumer.waitForMessagesToArrive(this.producer.getMessageCount());
        List<Message> messages = this.consumer.flushMessages();
        LOG.info("Consumer has received messages....");
        for (Message message : messages) {
            LOG.info("Received: " + message);
        }
        SpringTest.assertEquals((String)"Message count", (int)this.producer.getMessageCount(), (int)messages.size());
    }

    protected void tearDown() throws Exception {
        if (this.consumer != null) {
            this.consumer.stop();
        }
        if (this.producer != null) {
            this.producer.stop();
        }
        if (this.context != null) {
            this.context.destroy();
        }
    }

    protected void setUp() throws Exception {
        if (System.getProperty("basedir") == null) {
            File file = new File(".");
            System.setProperty("basedir", file.getAbsolutePath());
        }
        super.setUp();
    }
}

