/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.virtual;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.activemq.broker.jmx.MBeanTest;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.spring.ConsumerBean;

public class VirtualTopicsAndDurableSubsTest
extends MBeanTest {
    private Connection connection;

    public void testVirtualTopicCreationAndDurableSubs() throws Exception {
        if (this.connection == null) {
            this.connection = this.createConnection();
        }
        this.connection.setClientID(this.getAClientID());
        this.connection.start();
        ConsumerBean messageList = new ConsumerBean();
        messageList.setVerbose(true);
        String queueAName = this.getVirtualTopicConsumerName();
        ActiveMQQueue queue1 = new ActiveMQQueue(queueAName);
        ActiveMQQueue queue2 = new ActiveMQQueue(queueAName);
        Session session = this.connection.createSession(false, 1);
        MessageConsumer c1 = session.createConsumer((Destination)queue1);
        MessageConsumer c2 = session.createConsumer((Destination)queue2);
        c1.setMessageListener((MessageListener)messageList);
        c2.setMessageListener((MessageListener)messageList);
        MessageProducer producer = session.createProducer((Destination)new ActiveMQTopic(this.getVirtualTopicName()));
        VirtualTopicsAndDurableSubsTest.assertNotNull((Object)producer);
        int total = 10;
        for (int i = 0; i < total; ++i) {
            producer.send((Message)session.createTextMessage("message: " + i));
        }
        messageList.assertMessagesArrived(total);
        this.assertCreateAndDestroyDurableSubscriptions();
    }

    protected String getAClientID() {
        return "VirtualTopicCreationAndDurableSubs";
    }

    protected String getVirtualTopicName() {
        return "VirtualTopic.TEST";
    }

    protected String getVirtualTopicConsumerName() {
        return "Consumer.A.VirtualTopic.TEST";
    }

    protected String getDurableSubscriberName() {
        return "Sub1";
    }

    protected String getDurableSubscriberTopicName() {
        return "simple.topic";
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        super.tearDown();
    }

    @Override
    public void testMBeans() throws Exception {
    }

    @Override
    public void testMoveMessages() throws Exception {
    }

    @Override
    public void testRetryMessages() throws Exception {
    }

    @Override
    public void testMoveMessagesBySelector() throws Exception {
    }

    @Override
    public void testCopyMessagesBySelector() throws Exception {
    }
}

