/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.Serializable;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Session;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;

public class AMQ1282
extends TestCase {
    private ConnectionFactory factory;
    private Connection connection;
    private MapMessage message;

    protected void setUp() throws Exception {
        this.factory = new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false");
        this.connection = this.factory.createConnection();
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        this.message = session.createMapMessage();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        this.connection.close();
        super.tearDown();
    }

    public void testUnmappedBooleanMessage() throws JMSException {
        Serializable expected;
        try {
            expected = Boolean.valueOf(null);
        }
        catch (Exception ex) {
            expected = ex;
        }
        try {
            Boolean actual = this.message.getBoolean("foo");
            AMQ1282.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception ex) {
            AMQ1282.assertEquals((Object)expected, (Object)ex);
        }
    }

    public void testUnmappedIntegerMessage() throws JMSException {
        Serializable expected;
        try {
            expected = Integer.valueOf(null);
        }
        catch (Exception ex) {
            expected = ex;
        }
        try {
            Integer actual = this.message.getInt("foo");
            AMQ1282.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception ex) {
            Class<?> aClass = expected.getClass();
            AMQ1282.assertTrue((boolean)aClass.isInstance(ex));
        }
    }

    public void testUnmappedShortMessage() throws JMSException {
        Serializable expected;
        try {
            expected = Short.valueOf(null);
        }
        catch (Exception ex) {
            expected = ex;
        }
        try {
            Short actual = this.message.getShort("foo");
            AMQ1282.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception ex) {
            Class<?> aClass = expected.getClass();
            AMQ1282.assertTrue((boolean)aClass.isInstance(ex));
        }
    }

    public void testUnmappedLongMessage() throws JMSException {
        Serializable expected;
        try {
            expected = Long.valueOf(null);
        }
        catch (Exception ex) {
            expected = ex;
        }
        try {
            Long actual = this.message.getLong("foo");
            AMQ1282.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception ex) {
            Class<?> aClass = expected.getClass();
            AMQ1282.assertTrue((boolean)aClass.isInstance(ex));
        }
    }

    public void testUnmappedStringMessage() throws JMSException {
        Object expected;
        try {
            expected = String.valueOf(null);
        }
        catch (Exception ex) {
            expected = ex;
        }
        try {
            String actual = this.message.getString("foo");
            AMQ1282.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception ex) {
            Class<?> aClass = expected.getClass();
            AMQ1282.assertTrue((boolean)aClass.isInstance(ex));
        }
    }

    public void testUnmappedCharMessage() throws JMSException {
        try {
            this.message.getChar("foo");
            AMQ1282.fail((String)"should have thrown NullPointerException");
        }
        catch (NullPointerException success) {
            AMQ1282.assertNotNull((Object)success);
        }
    }

    public void testUnmappedByteMessage() throws JMSException {
        Serializable expected;
        try {
            expected = Byte.valueOf(null);
        }
        catch (Exception ex) {
            expected = ex;
        }
        try {
            Byte actual = this.message.getByte("foo");
            AMQ1282.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception ex) {
            Class<?> aClass = expected.getClass();
            AMQ1282.assertTrue((boolean)aClass.isInstance(ex));
        }
    }

    public void testUnmappedDoubleMessage() throws JMSException {
        Serializable expected;
        try {
            expected = Double.valueOf(null);
        }
        catch (Exception ex) {
            expected = ex;
        }
        try {
            Double actual = this.message.getDouble("foo");
            AMQ1282.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception ex) {
            Class<?> aClass = expected.getClass();
            AMQ1282.assertTrue((boolean)aClass.isInstance(ex));
        }
    }

    public void testUnmappedFloatMessage() throws JMSException {
        Serializable expected;
        try {
            expected = Float.valueOf(null);
        }
        catch (Exception ex) {
            expected = ex;
        }
        try {
            Float actual = Float.valueOf(this.message.getFloat("foo"));
            AMQ1282.assertEquals((Object)expected, (Object)actual);
        }
        catch (Exception ex) {
            Class<?> aClass = expected.getClass();
            AMQ1282.assertTrue((boolean)aClass.isInstance(ex));
        }
    }
}

