/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.File;
import java.util.concurrent.CountDownLatch;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.Test;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.apache.activemq.CombinationTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.util.Wait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ2314Test
extends CombinationTestSupport {
    public boolean consumeAll = false;
    public int deliveryMode = 1;
    private static final Logger LOG = LoggerFactory.getLogger(AMQ2314Test.class);
    private static final int MESSAGES_COUNT = 30000;
    private static byte[] buf = new byte[1024];
    private BrokerService broker;
    private String connectionUri;
    private static final long messageReceiveTimeout = 500L;
    Destination destination = new ActiveMQTopic("FooTwo");

    public void testRemoveSlowSubscriberWhacksTempStore() throws Exception {
        this.runProducerWithHungConsumer();
    }

    public void testMemoryUsageReleasedOnAllConsumed() throws Exception {
        this.consumeAll = true;
        this.runProducerWithHungConsumer();
        this.runProducerWithHungConsumer();
    }

    public void runProducerWithHungConsumer() throws Exception {
        final CountDownLatch consumerContinue = new CountDownLatch(1);
        final CountDownLatch consumerReady = new CountDownLatch(1);
        long origTempUsage = this.broker.getSystemUsage().getTempUsage().getUsage();
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.connectionUri);
        factory.setAlwaysSyncSend(true);
        ActiveMQPrefetchPolicy prefetch = new ActiveMQPrefetchPolicy();
        prefetch.setTopicPrefetch(500);
        factory.setPrefetchPolicy(prefetch);
        final Connection connection = factory.createConnection();
        connection.start();
        Thread producingThread = new Thread("Producing thread"){

            @Override
            public void run() {
                try {
                    Session session = connection.createSession(false, 1);
                    MessageProducer producer = session.createProducer(AMQ2314Test.this.destination);
                    producer.setDeliveryMode(AMQ2314Test.this.deliveryMode);
                    for (int idx = 0; idx < 30000; ++idx) {
                        TextMessage message = session.createTextMessage(new String(buf) + idx);
                        producer.send((Message)message);
                    }
                    producer.close();
                    session.close();
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        };
        Thread consumingThread = new Thread("Consuming thread"){

            @Override
            public void run() {
                try {
                    int count = 0;
                    Session session = connection.createSession(false, 1);
                    MessageConsumer consumer = session.createConsumer(AMQ2314Test.this.destination);
                    while (consumer.receive(500L) == null) {
                        consumerReady.countDown();
                    }
                    ++count;
                    LOG.info("Received one... waiting");
                    consumerContinue.await();
                    if (AMQ2314Test.this.consumeAll) {
                        LOG.info("Consuming the rest of the messages...");
                        while (consumer.receive(500L) != null) {
                            ++count;
                        }
                    }
                    LOG.info("consumer session closing: consumed count: " + count);
                    session.close();
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        };
        consumingThread.start();
        consumerReady.await();
        producingThread.start();
        producingThread.join();
        final long tempUsageBySubscription = this.broker.getSystemUsage().getTempUsage().getUsage();
        LOG.info("Orig Usage: " + origTempUsage + ", currentUsage: " + tempUsageBySubscription);
        AMQ2314Test.assertTrue((String)"some temp store has been used", (tempUsageBySubscription != origTempUsage ? 1 : 0) != 0);
        consumerContinue.countDown();
        consumingThread.join();
        connection.close();
        LOG.info("Subscription Usage: " + tempUsageBySubscription + ", endUsage: " + this.broker.getSystemUsage().getTempUsage().getUsage());
        AMQ2314Test.assertTrue((String)"temp usage decreased with removed sub", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return AMQ2314Test.this.broker.getSystemUsage().getTempUsage().getUsage() < tempUsageBySubscription;
            }
        }));
    }

    public void setUp() throws Exception {
        super.setAutoFail(true);
        super.setUp();
        this.broker = new BrokerService();
        this.broker.setDataDirectory("target" + File.separator + "activemq-data");
        this.broker.setPersistent(true);
        this.broker.setUseJmx(true);
        this.broker.setAdvisorySupport(false);
        this.broker.setDeleteAllMessagesOnStartup(true);
        this.broker.getSystemUsage().getMemoryUsage().setLimit(0x4000000L);
        this.broker.addConnector("tcp://localhost:0").setName("Default");
        this.broker.start();
        this.connectionUri = ((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString();
    }

    public void tearDown() throws Exception {
        this.broker.stop();
    }

    public static Test suite() {
        return AMQ2314Test.suite(AMQ2314Test.class);
    }
}

