/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBStore;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AMQ2983Test {
    private static final int MAX_CONSUMER = 10;
    private static final int MAX_MESSAGES = 2000;
    private static final String QUEUE_NAME = "test.queue";
    private BrokerService broker;
    private final CountDownLatch messageCountDown = new CountDownLatch(2000);
    private CleanableKahaDBStore kahaDB;

    @Before
    public void setup() throws Exception {
        this.broker = new BrokerService();
        this.broker.setDeleteAllMessagesOnStartup(true);
        this.broker.setPersistent(true);
        this.kahaDB = new CleanableKahaDBStore();
        this.kahaDB.setJournalMaxFileLength(262144);
        this.broker.setPersistenceAdapter((PersistenceAdapter)this.kahaDB);
        this.broker.start();
        this.broker.waitUntilStarted();
    }

    @After
    public void tearDown() throws Exception {
        this.broker.stop();
    }

    @Test
    public void testNoStickyKahaDbLogFilesOnConcurrentTransactionalConsumer() throws Exception {
        ArrayList<ConsumerThread> consumerThreads = new ArrayList<ConsumerThread>();
        for (int i = 0; i < 10; ++i) {
            ConsumerThread thread = new ConsumerThread();
            thread.start();
            consumerThreads.add(thread);
        }
        this.sendMessages();
        boolean allMessagesReceived = this.messageCountDown.await(60L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)allMessagesReceived);
        for (Thread thread : consumerThreads) {
            thread.join(TimeUnit.MILLISECONDS.convert(60L, TimeUnit.SECONDS));
            Assert.assertFalse((boolean)thread.isAlive());
        }
        this.kahaDB.forceCleanup();
        Assert.assertEquals((String)"Expect only one active KahaDB log file after cleanup", (long)1L, (long)this.kahaDB.getFileMapSize());
    }

    private void sendMessages() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost");
        Connection connection = factory.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)session.createQueue(QUEUE_NAME));
        producer.setDeliveryMode(2);
        for (int i = 0; i < 2000; ++i) {
            BytesMessage message = session.createBytesMessage();
            message.writeBytes(new byte[200]);
            producer.send((Message)message);
        }
        producer.close();
        session.close();
        connection.close();
    }

    private class ConsumerThread
    extends Thread {
        private ConsumerThread() {
        }

        @Override
        public void run() {
            try {
                ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost");
                Connection connection = factory.createConnection();
                connection.start();
                Session session = connection.createSession(true, 0);
                MessageConsumer consumer = session.createConsumer((Destination)session.createQueue(AMQ2983Test.QUEUE_NAME));
                do {
                    Message message;
                    if ((message = consumer.receive(200L)) == null) continue;
                    session.commit();
                    AMQ2983Test.this.messageCountDown.countDown();
                } while (AMQ2983Test.this.messageCountDown.getCount() != 0L);
                consumer.close();
                session.close();
                connection.close();
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
        }
    }

    private static class CleanableKahaDBStore
    extends KahaDBStore {
        private CleanableKahaDBStore() {
        }

        public void forceCleanup() throws IOException {
            this.checkpointCleanup(true);
        }

        public int getFileMapSize() throws IOException {
            this.indexLock.readLock().lock();
            try {
                int n = this.getJournal().getFileMap().size();
                return n;
            }
            finally {
                this.indexLock.readLock().unlock();
            }
        }
    }
}

