/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.network.DiscoveryNetworkConnector;
import org.apache.activemq.network.NetworkConnector;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ3274Test {
    private static final transient Logger LOG = LoggerFactory.getLogger(AMQ3274Test.class);
    protected static int Next_broker_num = 0;
    protected EmbeddedTcpBroker broker1 = new EmbeddedTcpBroker();
    protected EmbeddedTcpBroker broker2 = new EmbeddedTcpBroker();
    protected int nextEchoId = 0;
    protected boolean testError = false;
    protected int echoResponseFill = 0;

    public AMQ3274Test() throws Exception {
        this.broker1.coreConnectTo(this.broker2, true);
        this.broker2.coreConnectTo(this.broker1, true);
    }

    public void logMessage(String msg) {
        System.out.println(msg);
        System.out.flush();
    }

    public void testMessages(Session sess, MessageProducer req_prod, Destination resp_dest, int num_msg) throws Exception {
        MessageConsumer resp_cons = sess.createConsumer(resp_dest);
        MessageClient cons_client = new MessageClient(resp_cons, num_msg);
        cons_client.start();
        for (int cur = 0; cur < num_msg && !this.testError; ++cur) {
            TextMessage msg = sess.createTextMessage("MSG AAAA " + cur);
            msg.setIntProperty("SEQ", 100 + cur);
            msg.setStringProperty("TEST", "TOPO");
            msg.setJMSReplyTo(resp_dest);
            if (cur == num_msg - 1) {
                msg.setBooleanProperty("end-of-response", true);
            }
            req_prod.send((Message)msg);
        }
        cons_client.waitShutdown(5000L);
        if (cons_client.shutdown()) {
            LOG.debug("Consumer client shutdown complete");
        } else {
            LOG.debug("Consumer client shutdown incomplete!!!");
        }
        int tot_expected = num_msg * (this.echoResponseFill + 1);
        if (cons_client.getNumMsgReceived() == tot_expected) {
            LOG.info("Have " + tot_expected + " messages, as-expected");
        } else {
            LOG.error("Have " + cons_client.getNumMsgReceived() + " messages; expected " + tot_expected);
            this.testError = true;
        }
        resp_cons.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOneDest(Connection conn, Session sess, Destination cons_dest, String prod_broker_url, String cons_broker_url, int num_msg) throws Exception {
        int echo_id;
        AMQ3274Test aMQ3274Test = this;
        synchronized (aMQ3274Test) {
            echo_id = this.nextEchoId++;
        }
        String echo_queue_name = "echo.queue." + echo_id;
        LOG.trace("destroying the echo queue in case an old one exists");
        AMQ3274Test.removeQueue(conn, echo_queue_name);
        EchoService echo_svc = new EchoService(echo_queue_name, prod_broker_url);
        echo_svc.start();
        LOG.trace("Creating echo queue and producer");
        Queue prod_dest = sess.createQueue(echo_queue_name);
        MessageProducer msg_prod = sess.createProducer((Destination)prod_dest);
        this.testMessages(sess, msg_prod, cons_dest, num_msg);
        echo_svc.shutdown();
        msg_prod.close();
    }

    public void testTempTopic(String prod_broker_url, String cons_broker_url) throws Exception {
        int num_msg = 5;
        LOG.info("TESTING TEMP TOPICS " + prod_broker_url + " -> " + cons_broker_url + " (" + num_msg + " messages)");
        Connection conn = this.createConnection(cons_broker_url);
        conn.start();
        Session sess = conn.createSession(false, 1);
        LOG.trace("Creating destination");
        TemporaryTopic cons_dest = sess.createTemporaryTopic();
        this.testOneDest(conn, sess, (Destination)cons_dest, prod_broker_url, cons_broker_url, num_msg);
        sess.close();
        conn.close();
    }

    public void testTopic(String prod_broker_url, String cons_broker_url) throws Exception {
        int num_msg = 5;
        LOG.info("TESTING TOPICS " + prod_broker_url + " -> " + cons_broker_url + " (" + num_msg + " messages)");
        Connection conn = this.createConnection(cons_broker_url);
        conn.start();
        Session sess = conn.createSession(false, 1);
        String topic_name = "topotest2.perm.topic";
        LOG.trace("Removing existing Topic");
        AMQ3274Test.removeTopic(conn, topic_name);
        LOG.trace("Creating Topic, " + topic_name);
        Topic cons_dest = sess.createTopic(topic_name);
        this.testOneDest(conn, sess, (Destination)cons_dest, prod_broker_url, cons_broker_url, num_msg);
        AMQ3274Test.removeTopic(conn, topic_name);
        sess.close();
        conn.close();
    }

    public void testTempQueue(String prod_broker_url, String cons_broker_url) throws Exception {
        int num_msg = 5;
        LOG.info("TESTING TEMP QUEUES " + prod_broker_url + " -> " + cons_broker_url + " (" + num_msg + " messages)");
        Connection conn = this.createConnection(cons_broker_url);
        conn.start();
        Session sess = conn.createSession(false, 1);
        LOG.trace("Creating destination");
        TemporaryQueue cons_dest = sess.createTemporaryQueue();
        this.testOneDest(conn, sess, (Destination)cons_dest, prod_broker_url, cons_broker_url, num_msg);
        sess.close();
        conn.close();
    }

    public void testQueue(String prod_broker_url, String cons_broker_url) throws Exception {
        int num_msg = 5;
        LOG.info("TESTING QUEUES " + prod_broker_url + " -> " + cons_broker_url + " (" + num_msg + " messages)");
        Connection conn = this.createConnection(cons_broker_url);
        conn.start();
        Session sess = conn.createSession(false, 1);
        String queue_name = "topotest2.perm.queue";
        LOG.trace("Removing existing Queue");
        AMQ3274Test.removeQueue(conn, queue_name);
        LOG.trace("Creating Queue, " + queue_name);
        Queue cons_dest = sess.createQueue(queue_name);
        this.testOneDest(conn, sess, (Destination)cons_dest, prod_broker_url, cons_broker_url, num_msg);
        AMQ3274Test.removeQueue(conn, queue_name);
        sess.close();
        conn.close();
    }

    @Test
    public void run() throws Exception {
        this.testError = false;
        Thread start1 = new Thread(){

            @Override
            public void run() {
                try {
                    AMQ3274Test.this.broker1.start();
                }
                catch (Exception ex) {
                    LOG.error(null, (Throwable)ex);
                }
            }
        };
        Thread start2 = new Thread(){

            @Override
            public void run() {
                try {
                    AMQ3274Test.this.broker2.start();
                }
                catch (Exception ex) {
                    LOG.error(null, (Throwable)ex);
                }
            }
        };
        start1.start();
        start2.start();
        start1.join();
        start2.join();
        if (!this.testError) {
            this.testTempTopic(this.broker1.getConnectionUrl(), this.broker2.getConnectionUrl());
        }
        if (!this.testError) {
            this.testTempQueue(this.broker1.getConnectionUrl(), this.broker2.getConnectionUrl());
        }
        if (!this.testError) {
            this.testTopic(this.broker1.getConnectionUrl(), this.broker2.getConnectionUrl());
        }
        if (!this.testError) {
            this.testQueue(this.broker1.getConnectionUrl(), this.broker2.getConnectionUrl());
        }
        Thread.sleep(100L);
        this.shutdown();
        Assert.assertTrue((!this.testError ? 1 : 0) != 0);
    }

    public void shutdown() throws Exception {
        this.broker1.stop();
        this.broker2.stop();
    }

    public static void main(String[] args) {
        try {
            AMQ3274Test main_obj = new AMQ3274Test();
            main_obj.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LOG.error(null, (Throwable)ex);
            System.exit(0);
        }
    }

    protected Connection createConnection(String url) throws Exception {
        return ActiveMQConnection.makeConnection((String)url);
    }

    protected static void removeQueue(Connection conn, String dest_name) throws Exception {
        if (conn instanceof ActiveMQConnection) {
            ActiveMQDestination dest = ActiveMQDestination.createDestination((String)dest_name, (byte)1);
            ((ActiveMQConnection)conn).destroyDestination(dest);
        }
    }

    protected static void removeTopic(Connection conn, String dest_name) throws Exception {
        if (conn instanceof ActiveMQConnection) {
            ActiveMQDestination dest = ActiveMQDestination.createDestination((String)dest_name, (byte)2);
            ((ActiveMQConnection)conn).destroyDestination(dest);
        }
    }

    public static String fmtMsgInfo(Message msg) throws Exception {
        StringBuilder msg_desc = new StringBuilder();
        msg_desc = new StringBuilder();
        if (msg instanceof TextMessage) {
            msg_desc.append(((TextMessage)msg).getText());
        } else {
            msg_desc.append("[");
            msg_desc.append(msg.getClass().getName());
            msg_desc.append("]");
        }
        Enumeration prop_enum = msg.getPropertyNames();
        while (prop_enum.hasMoreElements()) {
            String prop = (String)prop_enum.nextElement();
            msg_desc.append("; ");
            msg_desc.append(prop);
            msg_desc.append("=");
            msg_desc.append(msg.getStringProperty(prop));
        }
        return msg_desc.toString();
    }

    protected class EchoService
    extends Thread {
        protected String destName;
        protected Connection jmsConn;
        protected Session sess;
        protected MessageConsumer msg_cons;
        protected boolean Shutdown_ind;
        protected Destination req_dest;
        protected Destination resp_dest;
        protected MessageProducer msg_prod;
        protected CountDownLatch waitShutdown;

        public EchoService(String dest, Connection broker_conn) throws Exception {
            this.destName = dest;
            this.jmsConn = broker_conn;
            this.Shutdown_ind = false;
            this.sess = this.jmsConn.createSession(false, 1);
            this.req_dest = this.sess.createQueue(this.destName);
            this.msg_cons = this.sess.createConsumer(this.req_dest);
            this.jmsConn.start();
            this.waitShutdown = new CountDownLatch(1);
        }

        public EchoService(String dest, String broker_url) throws Exception {
            this(dest, (Connection)ActiveMQConnection.makeConnection((String)broker_url));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                LOG.info("STARTING ECHO SERVICE");
                while (!this.Shutdown_ind) {
                    Message req = this.msg_cons.receive(100L);
                    if (req == null) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("ECHO request message " + req.toString());
                    }
                    this.resp_dest = req.getJMSReplyTo();
                    if (this.resp_dest != null) {
                        this.msg_prod = this.sess.createProducer(this.resp_dest);
                        this.msg_prod.send(req);
                        this.msg_prod.close();
                        this.msg_prod = null;
                        continue;
                    }
                    LOG.warn("invalid request: no reply-to destination given");
                }
            }
            catch (Exception ex) {
                LOG.error(null, (Throwable)ex);
            }
            finally {
                LOG.info("shutting down test echo service");
                try {
                    this.jmsConn.stop();
                }
                catch (JMSException jms_exc) {
                    LOG.warn("error on shutting down JMS connection", (Throwable)jms_exc);
                }
                EchoService echoService = this;
                synchronized (echoService) {
                    this.waitShutdown.countDown();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            CountDownLatch wait_l;
            EchoService echoService = this;
            synchronized (echoService) {
                wait_l = this.waitShutdown;
            }
            this.Shutdown_ind = true;
            try {
                if (wait_l != null) {
                    if (wait_l.await(3000L, TimeUnit.MILLISECONDS)) {
                        LOG.info("echo service shutdown complete");
                    } else {
                        LOG.warn("timeout waiting for echo service shutdown");
                    }
                } else {
                    LOG.info("echo service shutdown: service does not appear to be active");
                }
            }
            catch (InterruptedException int_exc) {
                LOG.warn("interrupted while waiting for echo service shutdown");
            }
        }
    }

    protected class MessageClient
    extends Thread {
        protected MessageConsumer msgCons;
        protected boolean shutdownInd;
        protected int expectedCount;
        protected int lastSeq = 0;
        protected int msgCount = 0;
        protected boolean haveFirstSeq;
        protected CountDownLatch shutdownLatch;

        public MessageClient(MessageConsumer cons, int num_to_expect) {
            this.msgCons = cons;
            this.expectedCount = num_to_expect * (AMQ3274Test.this.echoResponseFill + 1);
            this.shutdownLatch = new CountDownLatch(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                CountDownLatch latch;
                MessageClient messageClient = this;
                synchronized (messageClient) {
                    latch = this.shutdownLatch;
                }
                this.shutdownInd = false;
                this.processMessages();
                latch.countDown();
            }
            catch (Exception exc) {
                LOG.error("message client error", (Throwable)exc);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitShutdown(long timeout) {
            try {
                CountDownLatch latch;
                MessageClient messageClient = this;
                synchronized (messageClient) {
                    latch = this.shutdownLatch;
                }
                if (latch != null) {
                    latch.await(timeout, TimeUnit.MILLISECONDS);
                } else {
                    LOG.info("echo client shutdown: client does not appear to be active");
                }
            }
            catch (InterruptedException int_exc) {
                LOG.warn("wait for message client shutdown interrupted", (Throwable)int_exc);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean shutdown() {
            boolean down_ind;
            if (!this.shutdownInd) {
                this.shutdownInd = true;
            }
            this.waitShutdown(200L);
            MessageClient messageClient = this;
            synchronized (messageClient) {
                down_ind = this.shutdownLatch == null || this.shutdownLatch.getCount() == 0L;
            }
            return down_ind;
        }

        public int getNumMsgReceived() {
            return this.msgCount;
        }

        protected void processMessages() throws Exception {
            this.haveFirstSeq = false;
            while (!this.shutdownInd && !AMQ3274Test.this.testError) {
                Message in_msg = this.msgCons.receive(100L);
                if (in_msg == null) continue;
                ++this.msgCount;
                this.checkMessage(in_msg);
            }
        }

        protected void checkMessage(Message in_msg) throws Exception {
            LOG.debug("received message " + AMQ3274Test.fmtMsgInfo(in_msg));
            if (in_msg.propertyExists("SEQ")) {
                int seq = in_msg.getIntProperty("SEQ");
                if (this.haveFirstSeq && seq != this.lastSeq + 1) {
                    LOG.error("***ERROR*** incorrect sequence number; expected " + Integer.toString(this.lastSeq + 1) + " but have " + Integer.toString(seq));
                    AMQ3274Test.this.testError = true;
                }
                this.lastSeq = seq;
                if (this.msgCount > this.expectedCount) {
                    LOG.warn("*** have more messages than expected; have " + this.msgCount + "; expect " + this.expectedCount);
                    AMQ3274Test.this.testError = true;
                }
            }
            if (in_msg.propertyExists("end-of-response")) {
                LOG.trace("received end-of-response message");
                this.shutdownInd = true;
            }
        }
    }

    protected class EmbeddedTcpBroker {
        protected BrokerService brokerSvc = new BrokerService();
        protected int brokerNum;
        protected String brokerName;
        protected String brokerId;
        protected int port;
        protected String tcpUrl;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EmbeddedTcpBroker() throws Exception {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                this.brokerNum = Next_broker_num++;
            }
            this.brokerName = "broker" + this.brokerNum;
            this.brokerId = "b" + this.brokerNum;
            this.brokerSvc.setBrokerName(this.brokerName);
            this.brokerSvc.setBrokerId(this.brokerId);
            this.brokerSvc.setPersistent(false);
            this.brokerSvc.setUseJmx(false);
            this.tcpUrl = this.brokerSvc.addConnector("tcp://localhost:0").getPublishableConnectString();
        }

        public Connection createConnection() throws URISyntaxException, JMSException {
            ActiveMQConnection result = ActiveMQConnection.makeConnection((String)this.tcpUrl);
            return result;
        }

        public String getConnectionUrl() {
            return this.tcpUrl;
        }

        public void coreConnectTo(EmbeddedTcpBroker other, boolean duplex_f) throws Exception {
            this.makeConnectionTo(other, duplex_f, true);
            this.makeConnectionTo(other, duplex_f, false);
        }

        public void start() throws Exception {
            this.brokerSvc.start();
        }

        public void stop() throws Exception {
            this.brokerSvc.stop();
        }

        protected void makeConnectionTo(EmbeddedTcpBroker other, boolean duplex_f, boolean queue_f) throws Exception {
            ActiveMQDestination excl_dest;
            String prefix;
            DiscoveryNetworkConnector nw_conn = new DiscoveryNetworkConnector(new URI("static:(" + other.tcpUrl + ")"));
            nw_conn.setDuplex(duplex_f);
            if (queue_f) {
                nw_conn.setConduitSubscriptions(false);
            } else {
                nw_conn.setConduitSubscriptions(true);
            }
            nw_conn.setNetworkTTL(5);
            nw_conn.setSuppressDuplicateQueueSubscriptions(true);
            nw_conn.setDecreaseNetworkConsumerPriority(true);
            nw_conn.setBridgeTempDestinations(true);
            if (queue_f) {
                prefix = "queue";
                excl_dest = ActiveMQDestination.createDestination((String)">", (byte)1);
            } else {
                prefix = "topic";
                excl_dest = ActiveMQDestination.createDestination((String)">", (byte)2);
            }
            ArrayList<ActiveMQDestination> excludes = new ArrayList<ActiveMQDestination>();
            excludes.add(excl_dest);
            nw_conn.setExcludedDestinations(excludes);
            if (duplex_f) {
                nw_conn.setName(this.brokerId + "<-" + prefix + "->" + other.brokerId);
            } else {
                nw_conn.setName(this.brokerId + "-" + prefix + "->" + other.brokerId);
            }
            this.brokerSvc.addNetworkConnector((NetworkConnector)nw_conn);
        }
    }
}

