/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.FilePendingSubscriberMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.LastImageSubscriptionRecoveryPolicy;
import org.apache.activemq.broker.region.policy.PendingSubscriberMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.broker.region.policy.SubscriptionRecoveryPolicy;
import org.apache.activemq.transport.stomp.StompConnection;
import org.apache.activemq.util.DefaultTestAppender;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AMQ3622Test {
    protected BrokerService broker;
    protected AtomicBoolean failed = new AtomicBoolean(false);
    protected String connectionUri;
    protected Appender appender = new DefaultTestAppender(){

        public void doAppend(LoggingEvent event) {
            System.err.println(event.getMessage());
            if (event.getThrowableInformation() != null && event.getThrowableInformation().getThrowable() instanceof NullPointerException) {
                AMQ3622Test.this.failed.set(true);
            }
        }
    };

    @Before
    public void before() throws Exception {
        Logger.getRootLogger().addAppender(this.appender);
        this.broker = new BrokerService();
        this.broker.setDataDirectory("target" + File.separator + "activemq-data");
        this.broker.setPersistent(true);
        this.broker.setDeleteAllMessagesOnStartup(true);
        PolicyEntry policy = new PolicyEntry();
        policy.setTopic(">");
        policy.setProducerFlowControl(false);
        policy.setMemoryLimit(0x100000L);
        policy.setPendingSubscriberPolicy((PendingSubscriberMessageStoragePolicy)new FilePendingSubscriberMessageStoragePolicy());
        policy.setSubscriptionRecoveryPolicy((SubscriptionRecoveryPolicy)new LastImageSubscriptionRecoveryPolicy());
        policy.setExpireMessagesPeriod(500L);
        ArrayList<PolicyEntry> entries = new ArrayList<PolicyEntry>();
        entries.add(policy);
        PolicyMap pMap = new PolicyMap();
        pMap.setPolicyEntries(entries);
        this.broker.setDestinationPolicy(pMap);
        this.connectionUri = this.broker.addConnector("stomp://localhost:0").getPublishableConnectString();
        this.broker.start();
        this.broker.waitUntilStarted();
    }

    @After
    public void after() throws Exception {
        this.broker.stop();
        this.broker.waitUntilStopped();
        Logger.getRootLogger().removeAppender(this.appender);
    }

    @Test
    public void go() throws Exception {
        StompConnection connection = new StompConnection();
        Integer port = Integer.parseInt(this.connectionUri.split(":")[2]);
        connection.open("localhost", port.intValue());
        connection.connect("", "");
        connection.subscribe("/topic/foobar", "client");
        connection.disconnect();
        Thread.sleep(1000L);
        if (this.failed.get()) {
            Assert.fail((String)"Received NullPointerException");
        }
    }
}

