/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.util.LoggingBrokerPlugin;
import org.apache.activemq.util.DefaultTestAppender;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AMQ3779Test {
    private static final Logger LOG = Logger.getLogger(AMQ3779Test.class);
    private static final String qName = "QNameToFind";
    private BrokerService brokerService;
    private Appender appender;
    private final AtomicBoolean ok = new AtomicBoolean(false);

    @Before
    public void setUp() throws Exception {
        this.ok.set(false);
        this.appender = new DefaultTestAppender(){

            public void doAppend(LoggingEvent event) {
                if (event.getLoggerName().toString().contains(AMQ3779Test.qName)) {
                    AMQ3779Test.this.ok.set(true);
                }
            }
        };
        Logger.getRootLogger().addAppender(this.appender);
        try {
            this.brokerService = new BrokerService();
            LoggingBrokerPlugin loggingBrokerPlugin = new LoggingBrokerPlugin();
            loggingBrokerPlugin.setPerDestinationLogger(true);
            loggingBrokerPlugin.setLogAll(true);
            this.brokerService.setPlugins((BrokerPlugin[])new LoggingBrokerPlugin[]{loggingBrokerPlugin});
            this.brokerService.setPersistent(false);
            this.brokerService.setUseJmx(false);
            this.brokerService.start();
        }
        finally {
            LOG.removeAppender(this.appender);
        }
    }

    @After
    public void tearDown() throws Exception {
        try {
            if (this.brokerService != null) {
                this.brokerService.stop();
                this.brokerService.waitUntilStopped();
            }
        }
        finally {
            Logger.getRootLogger().removeAppender(this.appender);
        }
    }

    @Test(timeout=60000L)
    public void testLogPerDest() throws Exception {
        Connection connection = new ActiveMQConnectionFactory(this.brokerService.getVmConnectorURI()).createConnection();
        Session session = connection.createSession(false, 1);
        MessageProducer messageProducer = session.createProducer((Destination)session.createQueue(qName));
        messageProducer.setDeliveryMode(2);
        connection.start();
        messageProducer.send((Message)session.createTextMessage("Hi"));
        connection.close();
        Assert.assertTrue((String)"got expected log message", (boolean)this.ok.get());
    }
}

