/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AMQ4504Test {
    BrokerService brokerService;

    @Before
    public void setup() throws Exception {
        this.brokerService = new BrokerService();
        this.brokerService.setPersistent(false);
        this.brokerService.start();
    }

    @After
    public void stop() throws Exception {
        this.brokerService.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompositeDestConsumer() throws Exception {
        int numDests = 20;
        int numMessages = 200;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 20; ++i) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append("ST." + i);
        }
        stringBuffer.append("?consumer.prefetchSize=100");
        ActiveMQQueue activeMQQueue = new ActiveMQQueue(stringBuffer.toString());
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.brokerService.getVmConnectorURI());
        Connection connection = factory.createConnection();
        connection.start();
        MessageProducer producer = connection.createSession(false, 1).createProducer((Destination)activeMQQueue);
        for (int i = 0; i < 200; ++i) {
            producer.send((Message)new ActiveMQTextMessage());
        }
        MessageConsumer consumer = connection.createSession(false, 1).createConsumer((Destination)activeMQQueue);
        try {
            for (int i = 0; i < 4000; ++i) {
                Assert.assertNotNull((String)("recieved:" + i), (Object)consumer.receive(4000L));
            }
        }
        finally {
            connection.close();
        }
    }
}

