/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.File;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.RedeliveryPolicy;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.policy.RedeliveryPolicyMap;
import org.apache.activemq.broker.util.RedeliveryPlugin;
import org.apache.activemq.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedeliveryPluginHeaderTest
extends TestCase {
    private static final String TEST_QUEUE_ONE = "TEST_QUEUE_ONE";
    private static final String TEST_QUEUE_TWO = "TEST_QUEUE_TWO";
    private static final Logger LOG = LoggerFactory.getLogger(RedeliveryPluginHeaderTest.class);
    private String transportURL;
    private BrokerService broker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSendAfterRedelivery() throws Exception {
        this.broker = this.createBroker(false);
        this.broker.start();
        this.broker.waitUntilStarted();
        LOG.info("***Broker started...");
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.transportURL + "?trace=true&jms.redeliveryPolicy.maximumRedeliveries=0");
        Connection connection = factory.createConnection();
        connection.start();
        try {
            Session session = connection.createSession(true, 0);
            Queue destinationQ1 = session.createQueue(TEST_QUEUE_ONE);
            Queue destinationQ2 = session.createQueue(TEST_QUEUE_TWO);
            MessageProducer producerQ1 = session.createProducer((Destination)destinationQ1);
            producerQ1.setDeliveryMode(2);
            TextMessage m = session.createTextMessage("testMessage");
            LOG.info("*** send message to broker...");
            producerQ1.send((Message)m);
            session.commit();
            MessageConsumer consumerQ1 = session.createConsumer((Destination)destinationQ1);
            LOG.info("*** consume message from Q1 and rolled back..");
            TextMessage textMessage = (TextMessage)consumerQ1.receive();
            LOG.info("got redelivered: " + textMessage);
            RedeliveryPluginHeaderTest.assertFalse((String)"JMSRedelivered flag is not set", (boolean)textMessage.getJMSRedelivered());
            session.rollback();
            LOG.info("*** consumed message from Q1 again and sending to Q2..");
            TextMessage textMessage2 = (TextMessage)consumerQ1.receive();
            LOG.info("got: " + textMessage2);
            session.commit();
            RedeliveryPluginHeaderTest.assertTrue((String)"JMSRedelivered flag is set", (boolean)textMessage2.getJMSRedelivered());
            MessageConsumer consumerQ2 = session.createConsumer((Destination)destinationQ2);
            MessageProducer producer_two = session.createProducer((Destination)destinationQ2);
            producer_two.send((Message)textMessage2);
            session.commit();
            Message textMessage3 = consumerQ2.receive(1000L);
            RedeliveryPluginHeaderTest.assertNotNull((String)"should have consumed a message from TEST_QUEUE_TWO", (Object)textMessage3);
            RedeliveryPluginHeaderTest.assertFalse((String)"JMSRedelivered flag is not set", (boolean)textMessage3.getJMSRedelivered());
            session.commit();
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (this.broker != null) {
                this.broker.stop();
            }
        }
    }

    protected BrokerService createBroker(boolean withJMX) throws Exception {
        File schedulerDirectory = new File("target/scheduler");
        IOHelper.mkdirs((File)schedulerDirectory);
        IOHelper.deleteChildren((File)schedulerDirectory);
        BrokerService answer = new BrokerService();
        answer.setAdvisorySupport(false);
        answer.setDataDirectory("target");
        answer.setSchedulerDirectoryFile(schedulerDirectory);
        answer.setSchedulerSupport(true);
        answer.setPersistent(true);
        answer.setDeleteAllMessagesOnStartup(true);
        answer.setUseJmx(withJMX);
        RedeliveryPlugin redeliveryPlugin = new RedeliveryPlugin();
        RedeliveryPolicyMap redeliveryPolicyMap = new RedeliveryPolicyMap();
        RedeliveryPolicy defaultEntry = new RedeliveryPolicy();
        defaultEntry.setInitialRedeliveryDelay(5000L);
        defaultEntry.setMaximumRedeliveries(5);
        redeliveryPolicyMap.setDefaultEntry(defaultEntry);
        redeliveryPlugin.setRedeliveryPolicyMap(redeliveryPolicyMap);
        answer.setPlugins(new BrokerPlugin[]{redeliveryPlugin});
        TransportConnector transportConnector = answer.addConnector("tcp://localhost:0");
        this.transportURL = transportConnector.getConnectUri().toASCIIString();
        return answer;
    }
}

