/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.command;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.apache.activemq.CombinationTestSupport;
import org.apache.activemq.command.Command;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.wireformat.WireFormat;

public abstract class DataStructureTestSupport
extends CombinationTestSupport {
    public boolean cacheEnabled;
    public WireFormat wireFormat;

    public void assertBeanMarshalls(Object original) throws IOException {
        Object o = this.marshalAndUnmarshall(original, this.wireFormat);
        DataStructureTestSupport.assertNotNull((Object)o);
        DataStructureTestSupport.assertEquals(original, o);
    }

    public static void assertEquals(Object expect, Object was) {
        if (expect == null ^ was == null) {
            throw new AssertionFailedError("Not equals, expected: " + expect + ", was: " + was);
        }
        if (expect == null) {
            return;
        }
        if (expect.getClass() != was.getClass()) {
            throw new AssertionFailedError("Not equals, classes don't match. expected: " + expect.getClass() + ", was: " + was.getClass());
        }
        if (expect.getClass().isArray()) {
            Class<?> componentType = expect.getClass().getComponentType();
            if (componentType.isPrimitive()) {
                boolean ok = false;
                if (componentType == Byte.TYPE) {
                    ok = Arrays.equals((byte[])expect, (byte[])was);
                }
                if (componentType == Character.TYPE) {
                    ok = Arrays.equals((char[])expect, (char[])was);
                }
                if (componentType == Short.TYPE) {
                    ok = Arrays.equals((short[])expect, (short[])was);
                }
                if (componentType == Integer.TYPE) {
                    ok = Arrays.equals((int[])expect, (int[])was);
                }
                if (componentType == Long.TYPE) {
                    ok = Arrays.equals((long[])expect, (long[])was);
                }
                if (componentType == Double.TYPE) {
                    ok = Arrays.equals((double[])expect, (double[])was);
                }
                if (componentType == Float.TYPE) {
                    ok = Arrays.equals((float[])expect, (float[])was);
                }
                if (!ok) {
                    throw new AssertionFailedError("Arrays not equal");
                }
            } else {
                Object[] expectArray = (Object[])expect;
                Object[] wasArray = (Object[])was;
                if (expectArray.length != wasArray.length) {
                    throw new AssertionFailedError("Not equals, array lengths don't match. expected: " + expectArray.length + ", was: " + wasArray.length);
                }
                for (int i = 0; i < wasArray.length; ++i) {
                    DataStructureTestSupport.assertEquals(expectArray[i], wasArray[i]);
                }
            }
        } else if (expect instanceof Command) {
            DataStructureTestSupport.assertEquals(expect.getClass(), was.getClass());
            Method[] methods = expect.getClass().getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (!method.getName().startsWith("get") && !method.getName().startsWith("is") || method.getParameterTypes().length != 0 || method.getReturnType() == null) continue;
                try {
                    if (method.getName().startsWith("get")) {
                        expect.getClass().getMethod(method.getName().replaceFirst("get", "set"), method.getReturnType());
                    } else {
                        expect.getClass().getMethod(method.getName().replaceFirst("is", "set"), method.getReturnType());
                    }
                }
                catch (Throwable ignore) {
                    continue;
                }
                try {
                    DataStructureTestSupport.assertEquals(method.invoke(expect, new Object[]{null}), method.invoke(was, new Object[]{null}));
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    continue;
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        } else {
            TestCase.assertEquals((Object)expect, (Object)was);
        }
    }

    protected void setUp() throws Exception {
        this.wireFormat = this.createWireFormat();
        super.setUp();
    }

    protected WireFormat createWireFormat() {
        OpenWireFormat answer = new OpenWireFormat();
        answer.setCacheEnabled(this.cacheEnabled);
        return answer;
    }

    protected Object marshalAndUnmarshall(Object original, WireFormat wireFormat) throws IOException {
        ByteSequence packet = wireFormat.marshal(original);
        return wireFormat.unmarshal(packet);
    }
}

