/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.DestinationFilter;
import org.apache.activemq.broker.region.DestinationStatistics;
import org.apache.activemq.broker.region.DurableTopicSubscription;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.Topic;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.RemoveSubscriptionInfo;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.util.SubscriptionKey;
import org.apache.activemq.util.Wait;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;

public abstract class DynamicNetworkTestSupport {
    protected Connection localConnection;
    protected Connection remoteConnection;
    protected BrokerService localBroker;
    protected BrokerService remoteBroker;
    protected Session localSession;
    protected Session remoteSession;
    protected ActiveMQTopic included;
    protected ActiveMQTopic excluded;
    protected String testTopicName = "include.test.bar";
    protected String excludeTopicName = "exclude.test.bar";
    protected String clientId = "clientId";
    protected String subName = "subId";
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder(new File("target"));

    protected void doTearDown() throws Exception {
        this.stopLocalBroker();
        this.stopRemoteBroker();
    }

    protected void stopLocalBroker() throws Exception {
        if (this.localConnection != null) {
            this.localConnection.close();
        }
        if (this.localBroker != null) {
            this.localBroker.stop();
            this.localBroker.waitUntilStopped();
        }
    }

    protected void stopRemoteBroker() throws Exception {
        if (this.remoteConnection != null) {
            this.remoteConnection.close();
        }
        if (this.remoteBroker != null) {
            this.remoteBroker.stop();
            this.remoteBroker.waitUntilStopped();
        }
    }

    protected void assertBridgeStarted() throws Exception {
        Assert.assertTrue((boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return ((NetworkConnector)DynamicNetworkTestSupport.this.localBroker.getNetworkConnectors().get(0)).activeBridges().size() == 1;
            }
        }, (long)10000L, (long)500L));
    }

    protected RemoveSubscriptionInfo getRemoveSubscriptionInfo(ConnectionContext context, BrokerService brokerService) throws Exception {
        RemoveSubscriptionInfo info = new RemoveSubscriptionInfo();
        info.setClientId(this.clientId);
        info.setSubcriptionName(this.subName);
        context.setBroker(brokerService.getBroker());
        context.setClientId(this.clientId);
        return info;
    }

    protected void waitForConsumerCount(final DestinationStatistics destinationStatistics, final int count) throws Exception {
        Assert.assertTrue((boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return (long)count == destinationStatistics.getConsumers().getCount();
            }
        }));
    }

    protected void waitForDispatchFromLocalBroker(final DestinationStatistics destinationStatistics, final int count) throws Exception {
        Assert.assertTrue((boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return (long)count == destinationStatistics.getDequeues().getCount() && (long)count == destinationStatistics.getDispatched().getCount() && (long)count == destinationStatistics.getForwards().getCount();
            }
        }));
    }

    protected void assertLocalBrokerStatistics(DestinationStatistics localStatistics, int count) {
        Assert.assertEquals((String)"local broker dest stat dispatched", (long)count, (long)localStatistics.getDispatched().getCount());
        Assert.assertEquals((String)"local broker dest stat dequeues", (long)count, (long)localStatistics.getDequeues().getCount());
        Assert.assertEquals((String)"local broker dest stat forwards", (long)count, (long)localStatistics.getForwards().getCount());
    }

    protected void assertNCDurableSubsCount(final BrokerService brokerService, final ActiveMQTopic dest, final int count) throws Exception {
        Assert.assertTrue((boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return count == DynamicNetworkTestSupport.this.getNCDurableSubs(brokerService, dest).size();
            }
        }, (long)10000L, (long)500L));
    }

    protected void assertConsumersCount(final BrokerService brokerService, final ActiveMQTopic dest, final int count) throws Exception {
        Assert.assertTrue((boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return count == DynamicNetworkTestSupport.this.getConsumers(brokerService, dest).size();
            }
        }, (long)10000L, (long)500L));
    }

    protected List<Subscription> getConsumers(BrokerService brokerService, ActiveMQTopic dest) throws Exception {
        Topic destination = (Topic)brokerService.getDestination((ActiveMQDestination)dest);
        return destination.getConsumers();
    }

    protected List<DurableTopicSubscription> getSubscriptions(BrokerService brokerService, ActiveMQTopic dest) throws Exception {
        ArrayList<DurableTopicSubscription> subs = new ArrayList<DurableTopicSubscription>();
        Topic destination = (Topic)brokerService.getDestination((ActiveMQDestination)dest);
        for (SubscriptionKey key : destination.getDurableTopicSubs().keySet()) {
            DurableTopicSubscription sub;
            if (key.getSubscriptionName().startsWith("NC-DS_") || (sub = (DurableTopicSubscription)destination.getDurableTopicSubs().get(key)) == null) continue;
            subs.add(sub);
        }
        return subs;
    }

    protected List<DurableTopicSubscription> getNCDurableSubs(BrokerService brokerService, ActiveMQTopic dest) throws Exception {
        ArrayList<DurableTopicSubscription> subs = new ArrayList<DurableTopicSubscription>();
        Destination d = brokerService.getDestination((ActiveMQDestination)dest);
        Topic destination = null;
        destination = d instanceof DestinationFilter ? (Topic)((DestinationFilter)d).getAdaptor(Topic.class) : (Topic)d;
        for (SubscriptionKey key : destination.getDurableTopicSubs().keySet()) {
            DurableTopicSubscription sub;
            if (!key.getSubscriptionName().startsWith("NC-DS_") || (sub = (DurableTopicSubscription)destination.getDurableTopicSubs().get(key)) == null) continue;
            subs.add(sub);
        }
        return subs;
    }

    protected void removeSubscription(BrokerService brokerService, ActiveMQTopic topic, String subName) throws Exception {
        RemoveSubscriptionInfo info = new RemoveSubscriptionInfo();
        info.setClientId(this.clientId);
        info.setSubscriptionName(subName);
        ConnectionContext context = new ConnectionContext();
        context.setBroker(brokerService.getBroker());
        context.setClientId(this.clientId);
        brokerService.getBroker().removeSubscription(context, info);
    }

    protected void assertSubscriptionsCount(final BrokerService brokerService, final ActiveMQTopic dest, final int count) throws Exception {
        Assert.assertTrue((boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return count == DynamicNetworkTestSupport.this.getSubscriptions(brokerService, dest).size();
            }
        }, (long)10000L, (long)500L));
    }

    protected static interface ConsumerCreator {
        public MessageConsumer createConsumer() throws JMSException;
    }
}

