/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.openwire;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQConnectionMetaData;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.WireFormatInfo;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.openwire.OpenWireFormatFactory;
import org.apache.activemq.transport.DefaultTransportListener;
import org.apache.activemq.transport.TransportListener;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WireFormatInfoPropertiesTest {
    static final Logger LOG = LoggerFactory.getLogger(WireFormatInfoPropertiesTest.class);
    protected BrokerService master;
    protected String brokerUri;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientProperties() throws Exception {
        BrokerService service = this.createBrokerService();
        try {
            ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(new URI(this.brokerUri));
            ActiveMQConnection conn = (ActiveMQConnection)factory.createConnection();
            final AtomicReference clientWf = new AtomicReference();
            conn.addTransportListener((TransportListener)new DefaultTransportListener(){

                public void onCommand(Object command) {
                    if (command instanceof WireFormatInfo) {
                        clientWf.set((WireFormatInfo)command);
                    }
                }
            });
            conn.start();
            if (clientWf.get() == null) {
                Assert.fail((String)"Wire format info is null");
            }
            Assert.assertTrue((boolean)((WireFormatInfo)clientWf.get()).getProperties().containsKey("ProviderName"));
            Assert.assertTrue((boolean)((WireFormatInfo)clientWf.get()).getProperties().containsKey("ProviderVersion"));
            Assert.assertTrue((boolean)((WireFormatInfo)clientWf.get()).getProperties().containsKey("PlatformDetails"));
            Assert.assertTrue((boolean)((WireFormatInfo)clientWf.get()).getProviderName().equals("ActiveMQ"));
            Assert.assertTrue((boolean)((WireFormatInfo)clientWf.get()).getPlatformDetails().equals(ActiveMQConnectionMetaData.PLATFORM_DETAILS));
        }
        finally {
            this.stopBroker(service);
        }
    }

    @Test
    public void testMarshalClientProperties() throws IOException {
        OpenWireFormatFactory factory = new OpenWireFormatFactory();
        OpenWireFormat wf = (OpenWireFormat)factory.createWireFormat();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream ds = new DataOutputStream(buffer);
        WireFormatInfo orig = wf.getPreferedWireFormatInfo();
        wf.marshal((Object)orig, (DataOutput)ds);
        ds.close();
        ByteArrayInputStream in = new ByteArrayInputStream(buffer.toByteArray());
        DataInputStream dis = new DataInputStream(in);
        Object actual = wf.unmarshal((DataInput)dis);
        if (!(actual instanceof WireFormatInfo)) {
            Assert.fail((String)"Unknown type");
        }
        WireFormatInfo result = (WireFormatInfo)actual;
        Assert.assertTrue((boolean)result.getProviderName().equals(orig.getProviderName()));
        Assert.assertTrue((result.getProviderVersion() == null || result.getProviderVersion().equals(orig.getProviderVersion()) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)result.getPlatformDetails().equals(orig.getPlatformDetails()));
    }

    private BrokerService createBrokerService() throws Exception {
        BrokerService service = new BrokerService();
        TransportConnector connector = service.addConnector("tcp://localhost:0");
        this.brokerUri = connector.getPublishableConnectString();
        service.setPersistent(false);
        service.setUseJmx(false);
        service.setBrokerName("Master");
        service.start();
        service.waitUntilStarted();
        return service;
    }

    private void stopBroker(BrokerService service) throws Exception {
        if (service != null) {
            service.stop();
            service.waitUntilStopped();
        }
    }
}

