/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import java.net.URI;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQQueue;

public class JaasNetworkTest
extends TestCase {
    BrokerService broker1;
    BrokerService broker2;

    public void setUp() throws Exception {
        System.setProperty("java.security.auth.login.config", "src/test/resources/login.config");
        this.broker1 = BrokerFactory.createBroker((URI)new URI("xbean:org/apache/activemq/security/broker1.xml"));
        this.broker2 = BrokerFactory.createBroker((URI)new URI("xbean:org/apache/activemq/security/broker2.xml"));
        this.broker1.waitUntilStarted();
        this.broker2.waitUntilStarted();
        Thread.sleep(2000L);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.broker1.stop();
        this.broker1.waitUntilStopped();
        this.broker2.stop();
        this.broker2.waitUntilStopped();
    }

    public void testNetwork() throws Exception {
        System.setProperty("javax.net.ssl.trustStore", "src/test/resources/org/apache/activemq/security/client.ts");
        System.setProperty("javax.net.ssl.trustStorePassword", "password");
        System.setProperty("javax.net.ssl.trustStoreType", "jks");
        System.setProperty("javax.net.ssl.keyStore", "src/test/resources/org/apache/activemq/security/client.ks");
        System.setProperty("javax.net.ssl.keyStorePassword", "password");
        System.setProperty("javax.net.ssl.keyStoreType", "jks");
        ActiveMQConnectionFactory producerFactory = new ActiveMQConnectionFactory("ssl://localhost:61617");
        Connection producerConn = producerFactory.createConnection();
        Session producerSess = producerConn.createSession(false, 1);
        MessageProducer producer = producerSess.createProducer((Destination)new ActiveMQQueue("test"));
        producerConn.start();
        TextMessage sentMessage = producerSess.createTextMessage("test");
        producer.send((Message)sentMessage);
        ActiveMQConnectionFactory consumerFactory = new ActiveMQConnectionFactory("ssl://localhost:61618");
        Connection consumerConn = consumerFactory.createConnection();
        Session consumerSess = consumerConn.createSession(false, 1);
        consumerConn.start();
        MessageConsumer consumer = consumerSess.createConsumer((Destination)new ActiveMQQueue("test"));
        TextMessage receivedMessage = (TextMessage)consumer.receive(100L);
        JaasNetworkTest.assertEquals((Object)sentMessage, (Object)receivedMessage);
    }
}

