/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.directory.DirContext;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.jaas.GroupPrincipal;
import org.apache.activemq.security.LDAPAuthorizationMap;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifFiles;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.ldap.LdapServer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
@ApplyLdifFiles(value={"org/apache/activemq/security/AMQauth.ldif"})
public class LDAPAuthorizationMapTest
extends AbstractLdapTestUnit {
    private static LDAPAuthorizationMap authMap;
    public static LdapServer ldapServer;

    @Before
    public void setup() throws Exception {
        authMap = new LDAPAuthorizationMap();
        authMap.setConnectionURL("ldap://localhost:" + LDAPAuthorizationMapTest.getLdapServer().getPort());
        authMap.setTopicSearchMatchingFormat(new MessageFormat("uid={0},ou=topics,ou=destinations,o=ActiveMQ,ou=system"));
        authMap.setQueueSearchMatchingFormat(new MessageFormat("uid={0},ou=queues,ou=destinations,o=ActiveMQ,ou=system"));
        authMap.setAdvisorySearchBase("uid=ActiveMQ.Advisory,ou=topics,ou=destinations,o=ActiveMQ,ou=system");
        authMap.setTempSearchBase("uid=ActiveMQ.Temp,ou=topics,ou=destinations,o=ActiveMQ,ou=system");
    }

    @Test
    public void testOpen() throws Exception {
        DirContext ctx = authMap.open();
        HashSet<String> set = new HashSet<String>();
        NamingEnumeration<NameClassPair> list = ctx.list("ou=destinations,o=ActiveMQ,ou=system");
        while (list.hasMore()) {
            NameClassPair ncp = list.next();
            set.add(ncp.getName());
        }
        Assert.assertTrue((boolean)set.contains("ou=topics"));
        Assert.assertTrue((boolean)set.contains("ou=queues"));
    }

    @Test
    public void testGetAdminACLs() {
        ActiveMQQueue q1 = new ActiveMQQueue("queue1");
        Set aclsq1 = authMap.getAdminACLs((ActiveMQDestination)q1);
        Assert.assertEquals((long)1L, (long)aclsq1.size());
        Assert.assertTrue((boolean)aclsq1.contains(new GroupPrincipal("role1")));
        ActiveMQTopic t1 = new ActiveMQTopic("topic1");
        Set aclst1 = authMap.getAdminACLs((ActiveMQDestination)t1);
        Assert.assertEquals((long)1L, (long)aclst1.size());
        Assert.assertTrue((boolean)aclst1.contains(new GroupPrincipal("role1")));
    }

    @Test
    public void testGetReadACLs() {
        ActiveMQQueue q1 = new ActiveMQQueue("queue1");
        Set aclsq1 = authMap.getReadACLs((ActiveMQDestination)q1);
        Assert.assertEquals((long)1L, (long)aclsq1.size());
        Assert.assertTrue((boolean)aclsq1.contains(new GroupPrincipal("role1")));
        ActiveMQTopic t1 = new ActiveMQTopic("topic1");
        Set aclst1 = authMap.getReadACLs((ActiveMQDestination)t1);
        Assert.assertEquals((long)1L, (long)aclst1.size());
        Assert.assertTrue((boolean)aclst1.contains(new GroupPrincipal("role2")));
    }

    @Test
    public void testGetWriteACLs() {
        ActiveMQQueue q1 = new ActiveMQQueue("queue1");
        Set aclsq1 = authMap.getWriteACLs((ActiveMQDestination)q1);
        Assert.assertEquals((long)2L, (long)aclsq1.size());
        Assert.assertTrue((boolean)aclsq1.contains(new GroupPrincipal("role1")));
        Assert.assertTrue((boolean)aclsq1.contains(new GroupPrincipal("role2")));
        ActiveMQTopic t1 = new ActiveMQTopic("topic1");
        Set aclst1 = authMap.getWriteACLs((ActiveMQDestination)t1);
        Assert.assertEquals((long)1L, (long)aclst1.size());
        Assert.assertTrue((boolean)aclst1.contains(new GroupPrincipal("role3")));
    }

    @Test
    public void testComposite() {
        ActiveMQQueue q1 = new ActiveMQQueue("queue1,topic://topic1");
        Set aclsq1 = authMap.getWriteACLs((ActiveMQDestination)q1);
        Assert.assertEquals((long)0L, (long)aclsq1.size());
    }

    @Test
    public void testAdvisory() {
        ActiveMQTopic dest = AdvisorySupport.getConnectionAdvisoryTopic();
        Set acls = authMap.getWriteACLs((ActiveMQDestination)dest);
        Assert.assertEquals((long)1L, (long)acls.size());
        Assert.assertTrue((boolean)acls.contains(new GroupPrincipal("role3")));
    }

    @Test
    public void testTemp() {
        Set acls = authMap.getTempDestinationAdminACLs();
        Assert.assertEquals((long)1L, (long)acls.size());
        Assert.assertTrue((boolean)acls.contains(new GroupPrincipal("role1")));
    }
}

