/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.failover;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.util.Wait;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class FailoverBackupLeakTest {
    private static BrokerService s1;
    private static BrokerService s2;

    @BeforeClass
    public static void setUp() throws Exception {
        s1 = FailoverBackupLeakTest.buildBroker("broker1");
        s2 = FailoverBackupLeakTest.buildBroker("broker2");
        s1.start();
        s1.waitUntilStarted();
        s2.start();
        s2.waitUntilStarted();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (s2 != null) {
            s2.stop();
            s2.waitUntilStopped();
        }
        if (s1 != null) {
            s1.stop();
            s1.waitUntilStopped();
        }
    }

    private static String getConnectString(BrokerService service) throws Exception {
        return ((TransportConnector)service.getTransportConnectors().get(0)).getPublishableConnectString();
    }

    private static BrokerService buildBroker(String brokerName) throws Exception {
        BrokerService service = new BrokerService();
        service.setBrokerName(brokerName);
        service.setUseJmx(false);
        service.setPersistent(false);
        service.setUseShutdownHook(false);
        service.addConnector("tcp://0.0.0.0:0?transport.closeAsync=false");
        return service;
    }

    @Test
    public void backupNoRandomize() throws Exception {
        this.check("backup=true&randomize=false");
    }

    @Test
    public void priorityBackupNoRandomize() throws Exception {
        this.check("priorityBackup=true&randomize=false");
    }

    private void check(String connectionProperties) throws Exception {
        String s1URL = FailoverBackupLeakTest.getConnectString(s1);
        String s2URL = FailoverBackupLeakTest.getConnectString(s2);
        String uri = "failover://(" + s1URL + "," + s2URL + ")?" + connectionProperties;
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(uri);
        for (int i = 0; i < 10; ++i) {
            this.buildConnection((ConnectionFactory)factory);
        }
        Assert.assertTrue((String)(connectionProperties + " broker1 connection count not zero: was[" + this.getConnectionCount(s1) + "]"), (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return FailoverBackupLeakTest.this.getConnectionCount(s1) == 0;
            }
        }));
        Assert.assertTrue((String)(connectionProperties + " broker2 connection count not zero: was[" + this.getConnectionCount(s2) + "]"), (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return FailoverBackupLeakTest.this.getConnectionCount(s2) == 0;
            }
        }));
    }

    private int getConnectionCount(BrokerService service) {
        return ((TransportConnector)service.getTransportConnectors().get(0)).getConnections().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildConnection(ConnectionFactory local) throws JMSException {
        Connection conn = null;
        Session sess = null;
        try {
            conn = local.createConnection();
            sess = conn.createSession(false, 2);
        }
        finally {
            try {
                if (sess != null) {
                    sess.close();
                }
            }
            catch (JMSException jMSException) {}
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (JMSException jMSException) {}
        }
    }
}

