/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.PrefetchSubscription;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.TopicSubscription;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.Message;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class AMQ6477Test {
    static final Logger LOG = LoggerFactory.getLogger(AMQ6477Test.class);
    @Rule
    public TemporaryFolder dataDir = new TemporaryFolder();
    private BrokerService brokerService;
    private String connectionUri;
    private final ActiveMQQueue queue = new ActiveMQQueue("queue");
    private final ActiveMQTopic topic = new ActiveMQTopic("topic");
    private final int numMessages = 10;
    private Connection connection;
    private Session session;
    private SubType subType;
    private boolean persistent;

    @Parameterized.Parameters(name="subType={0},isPersistent={1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({SubType.QUEUE, false}, {SubType.TOPIC, false}, {SubType.DURABLE, false}, {SubType.QUEUE, true}, {SubType.TOPIC, true}, {SubType.DURABLE, true});
    }

    public AMQ6477Test(SubType subType, boolean persistent) {
        this.subType = subType;
        this.persistent = persistent;
    }

    @Before
    public void before() throws Exception {
        this.brokerService = new BrokerService();
        TransportConnector connector = this.brokerService.addConnector("tcp://localhost:0");
        this.connectionUri = connector.getPublishableConnectString();
        this.brokerService.setPersistent(this.persistent);
        this.brokerService.setDataDirectory(this.dataDir.getRoot().getAbsolutePath());
        this.brokerService.setUseJmx(false);
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry entry = new PolicyEntry();
        entry.setReduceMemoryFootprint(true);
        policyMap.setDefaultEntry(entry);
        this.brokerService.setDestinationPolicy(policyMap);
        this.brokerService.start();
        this.brokerService.waitUntilStarted();
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.connectionUri);
        this.connection = factory.createConnection();
        this.connection.setClientID("clientId");
        this.connection.start();
        this.session = this.connection.createSession(false, 1);
    }

    @After
    public void after() throws Exception {
        if (this.connection != null) {
            this.connection.stop();
        }
        if (this.brokerService != null) {
            this.brokerService.stop();
            this.brokerService.waitUntilStopped();
        }
    }

    @Test(timeout=30000L)
    public void testReduceMemoryFootprint() throws Exception {
        ActiveMQQueue destination = this.subType.equals((Object)SubType.QUEUE) ? this.queue : this.topic;
        MessageConsumer consumer = this.subType.equals((Object)SubType.DURABLE) ? this.session.createDurableSubscriber((Topic)this.topic, "sub1") : this.session.createConsumer((Destination)destination);
        MessageProducer producer = this.session.createProducer((Destination)destination);
        for (int i = 0; i < 10; ++i) {
            TextMessage m = this.session.createTextMessage("test");
            m.setStringProperty("test", "test");
            producer.send((javax.jms.Message)m);
        }
        Subscription sub = (Subscription)this.brokerService.getDestination((ActiveMQDestination)destination).getConsumers().get(0);
        List<MessageReference> messages = this.getSubscriptionMessages(sub);
        for (MessageReference ref : messages) {
            ActiveMQTextMessage message = (ActiveMQTextMessage)ref.getMessage();
            Field propertiesField = Message.class.getDeclaredField("properties");
            propertiesField.setAccessible(true);
            Field textField = ActiveMQTextMessage.class.getDeclaredField("text");
            textField.setAccessible(true);
            Assert.assertNull((Object)textField.get(message));
            Assert.assertNull((Object)propertiesField.get(message));
            Assert.assertNotNull((Object)message.getProperties());
            Assert.assertNotNull((Object)message.getText());
        }
        consumer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<MessageReference> getSubscriptionMessages(Subscription sub) throws Exception {
        Field dispatchedField = null;
        Field dispatchLockField = null;
        if (sub instanceof TopicSubscription) {
            dispatchedField = TopicSubscription.class.getDeclaredField("dispatched");
            dispatchLockField = TopicSubscription.class.getDeclaredField("dispatchLock");
        } else {
            dispatchedField = PrefetchSubscription.class.getDeclaredField("dispatched");
            dispatchLockField = PrefetchSubscription.class.getDeclaredField("dispatchLock");
        }
        dispatchedField.setAccessible(true);
        dispatchLockField.setAccessible(true);
        Object object = dispatchLockField.get(sub);
        synchronized (object) {
            return new ArrayList<MessageReference>((List)dispatchedField.get(sub));
        }
    }

    protected static enum SubType {
        QUEUE,
        TOPIC,
        DURABLE;

    }
}

