/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.net.URI;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import org.apache.activemq.JmsMultipleBrokersTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.util.MessageIdList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BacklogNetworkCrossTalkTest
extends JmsMultipleBrokersTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(BacklogNetworkCrossTalkTest.class);

    @Override
    protected BrokerService createBroker(String brokerName) throws Exception {
        BrokerService broker = new BrokerService();
        broker.setDeleteAllMessagesOnStartup(true);
        broker.setPersistent(true);
        broker.setUseJmx(false);
        broker.setBrokerName(brokerName);
        broker.addConnector(new URI("tcp://localhost:0"));
        this.brokers.put(brokerName, new JmsMultipleBrokersTestSupport.BrokerItem(this, broker));
        return broker;
    }

    public void testProduceConsume() throws Exception {
        this.createBroker("A");
        this.createBroker("B");
        NetworkConnector nc = this.bridgeBrokers("A", "B");
        nc.setDuplex(true);
        nc.setDispatchAsync(false);
        this.startAllBrokers();
        this.waitForBridgeFormation();
        int numMessages = 2000;
        ActiveMQDestination destA = this.createDestination("AAA", false);
        this.sendMessages("A", (Destination)destA, 2000);
        ActiveMQDestination destB = this.createDestination("BBB", false);
        this.sendMessages("B", (Destination)destB, 2000);
        LOG.info("starting consumers..");
        MessageConsumer clientA = this.createConsumer("A", (Destination)destB);
        MessageConsumer clientB = this.createConsumer("B", (Destination)destA);
        long maxWait = 300000L;
        MessageIdList listA = this.getConsumerMessages("A", clientA);
        listA.setMaximumDuration(300000L);
        listA.waitForMessagesToArrive(2000);
        MessageIdList listB = this.getConsumerMessages("B", clientB);
        listB.setMaximumDuration(300000L);
        listB.waitForMessagesToArrive(2000);
        BacklogNetworkCrossTalkTest.assertEquals((String)("got all on A" + listA.getMessageCount()), (int)2000, (int)listA.getMessageCount());
        BacklogNetworkCrossTalkTest.assertEquals((String)("got all on B" + listB.getMessageCount()), (int)2000, (int)listB.getMessageCount());
    }

    @Override
    public void setUp() throws Exception {
        this.messageSize = 500;
        super.setMaxTestTime(600000L);
        super.setAutoFail(true);
        super.setUp();
    }
}

