/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.io.File;
import javax.jms.Connection;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.TestSupport;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;

public class DurableSubscriptionActivationTest
extends TestSupport {
    private BrokerService broker;
    private Connection connection;
    private ActiveMQTopic topic;

    @Override
    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory("vm://" + this.getName());
    }

    @Override
    protected Connection createConnection() throws Exception {
        Connection rc = super.createConnection();
        rc.setClientID(this.getName());
        return rc;
    }

    protected void setUp() throws Exception {
        this.topic = (ActiveMQTopic)this.createDestination();
        this.createBroker(true);
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.destroyBroker();
    }

    protected void restartBroker() throws Exception {
        this.destroyBroker();
        this.createBroker(false);
    }

    private void createBroker(boolean delete) throws Exception {
        this.broker = BrokerFactory.createBroker((String)"broker:(vm://localhost)");
        this.broker.setKeepDurableSubsActive(true);
        this.broker.setPersistent(true);
        this.broker.setDeleteAllMessagesOnStartup(delete);
        KahaDBPersistenceAdapter kahadb = new KahaDBPersistenceAdapter();
        kahadb.setDirectory(new File("activemq-data/" + this.getName() + "-kahadb"));
        kahadb.setJournalMaxFileLength(512000);
        this.broker.setPersistenceAdapter((PersistenceAdapter)kahadb);
        this.broker.setBrokerName(this.getName());
        this.broker.setDestinations(new ActiveMQDestination[]{this.topic});
        this.broker.start();
        this.broker.waitUntilStarted();
        this.connection = this.createConnection();
    }

    private void destroyBroker() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        if (this.broker != null) {
            this.broker.stop();
            this.broker.waitUntilStopped();
        }
    }

    public void testActivateWithExistingTopic() throws Exception {
        Session session = this.connection.createSession(false, 1);
        session.createDurableSubscriber((Topic)this.topic, "SubsId");
        Destination d = this.broker.getDestination((ActiveMQDestination)this.topic);
        DurableSubscriptionActivationTest.assertTrue((String)("More than one consumer found: " + d.getConsumers().size()), (d.getConsumers().size() == 1 ? 1 : 0) != 0);
        this.restartBroker();
        d = this.broker.getDestination((ActiveMQDestination)this.topic);
        DurableSubscriptionActivationTest.assertTrue((String)("More than one consumer found: " + d.getConsumers().size()), (d.getConsumers().size() == 1 ? 1 : 0) != 0);
        session = this.connection.createSession(false, 1);
        session.createDurableSubscriber((Topic)this.topic, "SubsId");
        DurableSubscriptionActivationTest.assertTrue((String)("More than one consumer found: " + d.getConsumers().size()), (d.getConsumers().size() == 1 ? 1 : 0) != 0);
        this.connection.close();
        this.connection = this.createConnection();
        session = this.connection.createSession(false, 1);
        session.createDurableSubscriber((Topic)this.topic, "SubsId");
        DurableSubscriptionActivationTest.assertTrue((String)("More than one consumer found: " + d.getConsumers().size()), (d.getConsumers().size() == 1 ? 1 : 0) != 0);
    }
}

