/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.activemq.JmsMultipleBrokersTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.RegionBroker;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.util.ThreadTracker;
import org.apache.activemq.util.Wait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkOfTwentyBrokersTest
extends JmsMultipleBrokersTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkOfTwentyBrokersTest.class);

    @Override
    protected void bridgeAllBrokers() throws Exception {
        this.bridgeAllBrokers("TwentyBrokersTest", 1, false, false);
    }

    @Override
    protected void bridgeAllBrokers(String groupName, int ttl, boolean suppressduplicateQueueSubs) throws Exception {
        this.bridgeAllBrokers(groupName, ttl, suppressduplicateQueueSubs, false);
    }

    @Override
    protected void bridgeAllBrokers(String groupName, int ttl, boolean suppressduplicateQueueSubs, boolean decreasePriority) throws Exception {
        Collection brokerList = this.brokers.values();
        Iterator i = brokerList.iterator();
        while (i.hasNext()) {
            List networkConnectors;
            TransportConnector transport;
            BrokerService broker = ((JmsMultipleBrokersTestSupport.BrokerItem)i.next()).broker;
            List transportConnectors = broker.getTransportConnectors();
            if (transportConnectors.isEmpty()) {
                broker.addConnector(new URI("tcp://localhost:0"));
                transportConnectors = broker.getTransportConnectors();
            }
            if ((transport = (TransportConnector)transportConnectors.get(0)).getDiscoveryUri() == null) {
                transport.setDiscoveryUri(new URI("multicast://default?group=" + groupName));
            }
            if ((networkConnectors = broker.getNetworkConnectors()).isEmpty()) {
                broker.addNetworkConnector("multicast://default?group=" + groupName);
                networkConnectors = broker.getNetworkConnectors();
            }
            NetworkConnector nc = (NetworkConnector)networkConnectors.get(0);
            nc.setNetworkTTL(ttl);
            nc.setSuppressDuplicateQueueSubscriptions(suppressduplicateQueueSubs);
            nc.setDecreaseNetworkConsumerPriority(decreasePriority);
        }
        maxSetupTime = 8000;
    }

    @Override
    protected BrokerService createBroker(String brokerName) throws Exception {
        BrokerService broker = new BrokerService();
        broker.setPersistent(false);
        broker.setUseJmx(false);
        broker.setBrokerName(brokerName);
        broker.addConnector(new URI("tcp://localhost:0"));
        this.brokers.put(brokerName, new JmsMultipleBrokersTestSupport.BrokerItem(this, broker));
        return broker;
    }

    public void testBrokers() throws Exception {
        int i;
        int X = 20;
        LOG.info("Creating X Brokers");
        for (i = 0; i < X; ++i) {
            this.createBroker("Broker" + i);
        }
        this.bridgeAllBrokers();
        this.startAllBrokers();
        this.waitForBridgeFormation(X - 1);
        LOG.info("Waiting for complete formation");
        try {
            Thread.sleep(20000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.verifyPeerBrokerInfos(X - 1);
        LOG.info("Stopping half the brokers");
        for (i = 0; i < X / 2; ++i) {
            this.destroyBroker("Broker" + i);
        }
        LOG.info("Waiting for complete stop");
        try {
            Thread.sleep(20000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.verifyPeerBrokerInfos(X / 2 - 1);
        LOG.info("Recreating first half");
        for (i = 0; i < X / 2; ++i) {
            this.createBroker("Broker" + i);
        }
        this.bridgeAllBrokers();
        this.startAllBrokers();
        this.waitForBridgeFormation(X - 1);
        LOG.info("Waiting for complete reformation");
        try {
            Thread.sleep(20000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.verifyPeerBrokerInfos(X - 1);
    }

    public void testPeerBrokerCountHalfPeer() throws Exception {
        this.createBroker("A");
        this.createBroker("B");
        this.bridgeBrokers("A", "B");
        this.startAllBrokers();
        this.verifyPeerBrokerInfo((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get("A"), 1);
        this.verifyPeerBrokerInfo((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get("B"), 0);
    }

    public void testPeerBrokerCountHalfPeerTwice() throws Exception {
        this.createBroker("A");
        this.createBroker("B");
        this.bridgeBrokers("A", "B");
        this.bridgeBrokers("A", "B");
        this.startAllBrokers();
        this.verifyPeerBrokerInfo((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get("A"), 1);
        this.verifyPeerBrokerInfo((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get("B"), 0);
    }

    public void testPeerBrokerCountFullPeer() throws Exception {
        this.createBroker("A");
        this.createBroker("B");
        this.bridgeBrokers("A", "B");
        this.bridgeBrokers("B", "A");
        this.startAllBrokers();
        this.verifyPeerBrokerInfo((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get("A"), 1);
        this.verifyPeerBrokerInfo((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get("B"), 1);
    }

    public void testPeerBrokerCountFullPeerDuplex() throws Exception {
        this.createBroker("A");
        this.createBroker("B");
        NetworkConnector nc = this.bridgeBrokers("A", "B");
        nc.setDuplex(true);
        this.startAllBrokers();
        this.verifyPeerBrokerInfo((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get("A"), 1);
        this.verifyPeerBrokerInfo((JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get("B"), 1);
    }

    private void verifyPeerBrokerInfo(JmsMultipleBrokersTestSupport.BrokerItem brokerItem, final int max) throws Exception {
        final BrokerService broker = brokerItem.broker;
        final RegionBroker regionBroker = (RegionBroker)broker.getRegionBroker();
        Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                LOG.info("verify infos " + broker.getBrokerName() + ", len: " + regionBroker.getPeerBrokerInfos().length);
                return max == regionBroker.getPeerBrokerInfos().length;
            }
        }, (long)120000L);
        LOG.info("verify infos " + broker.getBrokerName() + ", len: " + regionBroker.getPeerBrokerInfos().length);
        for (BrokerInfo info : regionBroker.getPeerBrokerInfos()) {
            LOG.info(info.getBrokerName());
        }
        NetworkOfTwentyBrokersTest.assertEquals((String)broker.getBrokerName(), (int)max, (int)regionBroker.getPeerBrokerInfos().length);
    }

    private void verifyPeerBrokerInfos(int max) throws Exception {
        Collection brokerList = this.brokers.values();
        Iterator i = brokerList.iterator();
        while (i.hasNext()) {
            this.verifyPeerBrokerInfo((JmsMultipleBrokersTestSupport.BrokerItem)i.next(), max);
        }
    }

    @Override
    public void setUp() throws Exception {
        super.setAutoFail(true);
        super.setUp();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        ThreadTracker.result();
    }
}

