/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQTopic;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicSubscriptionZeroPrefetchTest {
    private static final Logger LOG = LoggerFactory.getLogger(TopicSubscriptionZeroPrefetchTest.class);
    @Rule
    public TestName name = new TestName();
    private Connection connection;
    private Session session;
    private ActiveMQTopic destination;
    private MessageProducer producer;
    private MessageConsumer consumer;
    private BrokerService brokerService;

    public String getTopicName() {
        return this.name.getMethodName();
    }

    @Before
    public void setUp() throws Exception {
        this.brokerService = this.createBroker();
        ActiveMQConnectionFactory activeMQConnectionFactory = new ActiveMQConnectionFactory("vm://localhost");
        activeMQConnectionFactory.setWatchTopicAdvisories(true);
        this.connection = activeMQConnectionFactory.createConnection();
        this.connection.setClientID("ClientID-1");
        this.session = this.connection.createSession(false, 1);
        this.destination = new ActiveMQTopic(this.getTopicName());
        this.producer = this.session.createProducer((Destination)this.destination);
        this.connection.start();
    }

    @Test(timeout=60000L)
    public void testTopicConsumerPrefetchZero() throws Exception {
        ActiveMQTopic consumerDestination = new ActiveMQTopic(this.getTopicName() + "?consumer.retroactive=true&consumer.prefetchSize=0");
        this.consumer = this.session.createConsumer((Destination)consumerDestination);
        TextMessage txtMessage = this.session.createTextMessage("M");
        this.producer.send((Message)txtMessage);
        Message consumedMessage = this.consumer.receiveNoWait();
        Assert.assertNotNull((String)"should have received a message the published message", (Object)consumedMessage);
    }

    @Test(timeout=60000L)
    public void testTopicConsumerPrefetchZeroClientAckLoopReceive() throws Exception {
        int i;
        ActiveMQTopic consumerDestination = new ActiveMQTopic(this.getTopicName() + "?consumer.retroactive=true&consumer.prefetchSize=0");
        Session consumerClientAckSession = this.connection.createSession(false, 2);
        this.consumer = consumerClientAckSession.createConsumer((Destination)consumerDestination);
        int count = 10;
        for (i = 0; i < 10; ++i) {
            TextMessage txtMessage = this.session.createTextMessage("M:" + i);
            this.producer.send((Message)txtMessage);
        }
        for (i = 0; i < 10; ++i) {
            Message consumedMessage = this.consumer.receive();
            Assert.assertNotNull((String)("should have received message[" + i + "]"), (Object)consumedMessage);
        }
    }

    @Test(timeout=60000L)
    public void testTopicConsumerPrefetchZeroClientAckLoopTimedReceive() throws Exception {
        int i;
        ActiveMQTopic consumerDestination = new ActiveMQTopic(this.getTopicName() + "?consumer.retroactive=true&consumer.prefetchSize=0");
        Session consumerClientAckSession = this.connection.createSession(false, 2);
        this.consumer = consumerClientAckSession.createConsumer((Destination)consumerDestination);
        int count = 10;
        for (i = 0; i < 10; ++i) {
            TextMessage txtMessage = this.session.createTextMessage("M:" + i);
            this.producer.send((Message)txtMessage);
        }
        for (i = 0; i < 10; ++i) {
            Message consumedMessage = this.consumer.receive(2000L);
            Assert.assertNotNull((String)("should have received message[" + i + "]"), (Object)consumedMessage);
        }
    }

    @Test(timeout=60000L)
    public void testTopicConsumerPrefetchZeroClientAckLoopReceiveNoWait() throws Exception {
        int i;
        ActiveMQTopic consumerDestination = new ActiveMQTopic(this.getTopicName() + "?consumer.retroactive=true&consumer.prefetchSize=0");
        Session consumerClientAckSession = this.connection.createSession(false, 2);
        this.consumer = consumerClientAckSession.createConsumer((Destination)consumerDestination);
        int count = 10;
        for (i = 0; i < 10; ++i) {
            TextMessage txtMessage = this.session.createTextMessage("M:" + i);
            this.producer.send((Message)txtMessage);
        }
        for (i = 0; i < 10; ++i) {
            Message consumedMessage = this.consumer.receiveNoWait();
            Assert.assertNotNull((String)("should have received message[" + i + "]"), (Object)consumedMessage);
        }
    }

    @Test(timeout=60000L)
    public void testTopicConsumerPrefetchZeroConcurrentProduceConsumeAutoAck() throws Exception {
        this.doTestTopicConsumerPrefetchZeroConcurrentProduceConsume(1);
    }

    @Test(timeout=60000L)
    public void testTopicConsumerPrefetchZeroConcurrentProduceConsumeClientAck() throws Exception {
        this.doTestTopicConsumerPrefetchZeroConcurrentProduceConsume(2);
    }

    @Test(timeout=60000L)
    public void testTopicConsumerPrefetchZeroConcurrentProduceConsumeDupsOk() throws Exception {
        this.doTestTopicConsumerPrefetchZeroConcurrentProduceConsume(3);
    }

    @Test(timeout=60000L)
    public void testTopicConsumerPrefetchZeroConcurrentProduceConsumeTransacted() throws Exception {
        this.doTestTopicConsumerPrefetchZeroConcurrentProduceConsume(0);
    }

    @Test(timeout=60000L)
    public void testTopicConsumerPrefetchZeroConcurrentProduceConsumeTransactedComitInBatches() throws Exception {
        this.doTestTopicConsumerPrefetchZeroConcurrentProduceConsume(0);
    }

    @Test(timeout=60000L)
    public void testTopicConsumerPrefetchZeroConcurrentProduceConsumeIndividual() throws Exception {
        this.doTestTopicConsumerPrefetchZeroConcurrentProduceConsume(4);
    }

    private void doTestTopicConsumerPrefetchZeroConcurrentProduceConsume(int ackMode) throws Exception {
        this.doTestTopicConsumerPrefetchZeroConcurrentProduceConsume(ackMode, false);
    }

    private void doTestTopicConsumerPrefetchZeroConcurrentProduceConsume(final int ackMode, final boolean commitBatch) throws Exception {
        ActiveMQTopic consumerDestination = new ActiveMQTopic(this.getTopicName() + "?consumer.retroactive=true&consumer.prefetchSize=0");
        final Session consumerSession = this.connection.createSession(ackMode == 0, ackMode);
        this.consumer = consumerSession.createConsumer((Destination)consumerDestination);
        int MSG_COUNT = 2000;
        final AtomicBoolean error = new AtomicBoolean();
        final CountDownLatch done = new CountDownLatch(2000);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    for (int i = 0; i < 2000; ++i) {
                        Message consumedMessage = TopicSubscriptionZeroPrefetchTest.this.consumer.receive();
                        if (consumedMessage == null) continue;
                        done.countDown();
                        consumedMessage.acknowledge();
                        if (ackMode != 0 || !commitBatch || (i + 1) % 50 != 0) continue;
                        consumerSession.commit();
                    }
                }
                catch (Exception ex) {
                    LOG.error("Caught exception during receive: {}", (Throwable)ex);
                    error.set(true);
                }
                finally {
                    if (ackMode == 0) {
                        try {
                            consumerSession.commit();
                        }
                        catch (JMSException e) {
                            LOG.error("Caught exception on commit: {}", (Throwable)e);
                            error.set(true);
                        }
                    }
                }
            }
        });
        for (int i = 0; i < 2000; ++i) {
            TextMessage txtMessage = this.session.createTextMessage("M:" + i);
            this.producer.send((Message)txtMessage);
        }
        Assert.assertFalse((String)"Should not have gotten any errors", (boolean)error.get());
        Assert.assertTrue((String)"Should have read all messages", (boolean)done.await(10L, TimeUnit.SECONDS));
    }

    @Test(timeout=60000L)
    public void testDurableTopicConsumerPrefetchZero() throws Exception {
        ActiveMQTopic consumerDestination = new ActiveMQTopic(this.getTopicName() + "?consumer.prefetchSize=0");
        this.consumer = this.session.createDurableSubscriber((Topic)consumerDestination, "mysub1");
        TextMessage txtMessage = this.session.createTextMessage("M");
        this.producer.send((Message)txtMessage);
        Message consumedMessage = this.consumer.receive(100L);
        Assert.assertNotNull((String)"should have received a message the published message", (Object)consumedMessage);
    }

    @After
    public void tearDown() throws Exception {
        this.consumer.close();
        this.producer.close();
        this.session.close();
        this.connection.close();
        this.brokerService.stop();
    }

    private BrokerService createBroker() throws Exception {
        BrokerService broker = new BrokerService();
        broker.setBrokerName("localhost");
        broker.setUseJmx(false);
        broker.setDeleteAllMessagesOnStartup(true);
        broker.addConnector("vm://localhost");
        broker.start();
        broker.waitUntilStarted();
        return broker;
    }
}

