/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JmsMessageConsumerClosedTest {
    private Connection connection;
    private MessageConsumer consumer;
    private Destination destination;
    private BrokerService brokerService;

    protected BrokerService createBroker() throws Exception {
        BrokerService brokerService = new BrokerService();
        brokerService.setPersistent(false);
        brokerService.setUseJmx(false);
        brokerService.setAdvisorySupport(false);
        return brokerService;
    }

    protected MessageConsumer createClosedConsumer() throws Exception {
        MessageConsumer consumer = this.createConsumer();
        consumer.close();
        return consumer;
    }

    protected MessageConsumer createConsumer() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost?create=false");
        this.connection = factory.createConnection();
        Session session = this.connection.createSession(false, 1);
        this.destination = session.createTopic("test");
        return session.createConsumer(this.destination);
    }

    @Before
    public void setUp() throws Exception {
        this.brokerService = this.createBroker();
        this.brokerService.start();
        this.brokerService.waitUntilStarted();
        this.consumer = this.createClosedConsumer();
    }

    @After
    public void tearDown() throws Exception {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.brokerService != null) {
            this.brokerService.stop();
            this.brokerService.waitUntilStopped();
        }
    }

    @Test(timeout=30000L)
    public void testCloseWhileReceiveIsBlocked() throws Exception {
        final MessageConsumer consumer = this.createConsumer();
        Thread closer = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(2000L);
                    consumer.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        closer.start();
        Assert.assertNull((Object)consumer.receive());
    }

    @Test(timeout=30000L)
    public void testCloseWhileTimedReceiveIsBlocked() throws Exception {
        final MessageConsumer consumer = this.createConsumer();
        Thread closer = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(2000L);
                    consumer.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        closer.start();
        Assert.assertNull((Object)consumer.receive(5000L));
    }

    @Test(timeout=30000L, expected=IllegalStateException.class)
    public void testGetMessageSelectorFails() throws Exception {
        this.consumer.getMessageSelector();
    }

    @Test(timeout=30000L, expected=IllegalStateException.class)
    public void testGetMessageListenerFails() throws Exception {
        this.consumer.getMessageListener();
    }

    @Test(timeout=30000L, expected=IllegalStateException.class)
    public void testSetMessageListenerFails() throws Exception {
        this.consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
            }
        });
    }

    @Test(timeout=30000L, expected=IllegalStateException.class)
    public void testRreceiveFails() throws Exception {
        this.consumer.receive();
    }

    @Test(timeout=30000L, expected=IllegalStateException.class)
    public void testRreceiveTimedFails() throws Exception {
        this.consumer.receive(11L);
    }

    @Test(timeout=30000L, expected=IllegalStateException.class)
    public void testRreceiveNoWaitFails() throws Exception {
        this.consumer.receiveNoWait();
    }

    @Test(timeout=30000L)
    public void testClose() throws Exception {
        this.consumer.close();
    }
}

