/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class JmsMessageConsumerTest {
    private BrokerService brokerService;
    private String brokerURI;
    @Rule
    public TestName name = new TestName();

    @Before
    public void startBroker() throws Exception {
        this.brokerService = new BrokerService();
        this.brokerService.setPersistent(false);
        this.brokerService.setUseJmx(false);
        this.brokerService.start();
        this.brokerService.waitUntilStarted();
        this.brokerURI = "vm://localhost?create=false";
    }

    @After
    public void stopBroker() throws Exception {
        if (this.brokerService != null) {
            this.brokerService.stop();
        }
    }

    @Test
    public void testSyncReceiveWithExpirationChecks() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.brokerURI);
        Connection connection = factory.createConnection();
        Session session = connection.createSession(false, 1);
        Queue destination = session.createQueue(this.name.getMethodName());
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        MessageProducer producer = session.createProducer((Destination)destination);
        producer.setTimeToLive(TimeUnit.SECONDS.toMillis(2L));
        connection.start();
        producer.send((Message)session.createTextMessage("test"));
        TimeUnit.SECONDS.sleep(4L);
        Assert.assertNull((Object)consumer.receive(1000L));
        connection.close();
    }

    @Test
    public void testSyncReceiveWithIgnoreExpirationChecks() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.brokerURI);
        factory.setConsumerExpiryCheckEnabled(false);
        Connection connection = factory.createConnection();
        Session session = connection.createSession(false, 1);
        Queue destination = session.createQueue(this.name.getMethodName());
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        MessageProducer producer = session.createProducer((Destination)destination);
        producer.setTimeToLive(TimeUnit.SECONDS.toMillis(2L));
        connection.start();
        producer.send((Message)session.createTextMessage("test"));
        TimeUnit.SECONDS.sleep(4L);
        Assert.assertNotNull((Object)consumer.receive(1000L));
        connection.close();
    }

    @Test
    public void testAsyncReceiveWithExpirationChecks() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.brokerURI);
        final CountDownLatch received = new CountDownLatch(1);
        Connection connection = factory.createConnection();
        Session session = connection.createSession(false, 1);
        Queue destination = session.createQueue(this.name.getMethodName());
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                received.countDown();
            }
        });
        MessageProducer producer = session.createProducer((Destination)destination);
        producer.setTimeToLive(TimeUnit.SECONDS.toMillis(2L));
        producer.send((Message)session.createTextMessage("test"));
        TimeUnit.SECONDS.sleep(4L);
        connection.start();
        Assert.assertFalse((boolean)received.await(1L, TimeUnit.SECONDS));
        connection.close();
    }

    @Test
    public void testAsyncReceiveWithoutExpirationChecks() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.brokerURI);
        factory.setConsumerExpiryCheckEnabled(false);
        final CountDownLatch received = new CountDownLatch(1);
        Connection connection = factory.createConnection();
        Session session = connection.createSession(false, 1);
        Queue destination = session.createQueue(this.name.getMethodName());
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                received.countDown();
            }
        });
        MessageProducer producer = session.createProducer((Destination)destination);
        producer.setTimeToLive(TimeUnit.SECONDS.toMillis(2L));
        producer.send((Message)session.createTextMessage("test"));
        TimeUnit.SECONDS.sleep(4L);
        connection.start();
        Assert.assertTrue((boolean)received.await(5L, TimeUnit.SECONDS));
        connection.close();
    }
}

