/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ActiveMQDestination;

public class ReconnectWithJMXEnabledTest
extends EmbeddedBrokerTestSupport {
    protected Connection connection;
    protected boolean transacted;
    protected int authMode = 1;

    public void testTestUseConnectionCloseBrokerThenRestartInSameJVM() throws Exception {
        this.connection = this.connectionFactory.createConnection();
        this.useConnection(this.connection);
        this.connection.close();
        this.broker.stop();
        this.broker = this.createBroker();
        this.startBroker();
        this.connectionFactory = this.createConnectionFactory();
        this.connection = this.connectionFactory.createConnection();
        this.useConnection(this.connection);
    }

    @Override
    protected void setUp() throws Exception {
        this.bindAddress = "tcp://localhost:0";
        super.setUp();
    }

    @Override
    protected ConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory(((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString());
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
        super.tearDown();
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        answer.setUseJmx(true);
        answer.setPersistent(this.isPersistent());
        answer.addConnector(this.bindAddress);
        return answer;
    }

    protected void useConnection(Connection connection) throws Exception {
        connection.setClientID("foo");
        connection.start();
        Session session = connection.createSession(this.transacted, this.authMode);
        ActiveMQDestination destination = this.createDestination();
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        MessageProducer producer = session.createProducer((Destination)destination);
        TextMessage message = session.createTextMessage("Hello World");
        producer.send((Message)message);
        Thread.sleep(1000L);
        consumer.close();
    }
}

