/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import org.apache.activemq.broker.QueueSubscriptionTest;
import org.apache.activemq.util.ThreadTracker;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.BlockJUnit4ClassRunner;

@RunWith(value=BlockJUnit4ClassRunner.class)
public class TopicSubscriptionTest
extends QueueSubscriptionTest {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.durable = true;
        this.topic = true;
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        ThreadTracker.result();
    }

    @Override
    @Test(timeout=60000L)
    public void testManyProducersManyConsumers() throws Exception {
        this.consumerCount = 40;
        this.producerCount = 20;
        this.messageCount = 100;
        this.messageSize = 1;
        this.prefetchCount = 10;
        this.doMultipleClientsTest();
        this.assertTotalMessagesReceived(this.messageCount * this.producerCount * this.consumerCount);
        this.assertDestinationMemoryUsageGoesToZero();
    }

    @Override
    @Test(timeout=60000L)
    public void testOneProducerTwoConsumersLargeMessagesOnePrefetch() throws Exception {
        this.consumerCount = 2;
        this.producerCount = 1;
        this.messageCount = 10;
        this.messageSize = 0x100000;
        this.prefetchCount = 1;
        this.doMultipleClientsTest();
        this.assertTotalMessagesReceived(this.messageCount * this.consumerCount * this.producerCount);
        this.assertDestinationMemoryUsageGoesToZero();
    }

    @Override
    @Test(timeout=60000L)
    public void testOneProducerTwoConsumersSmallMessagesOnePrefetch() throws Exception {
        this.consumerCount = 2;
        this.producerCount = 1;
        this.prefetchCount = 1;
        this.messageSize = 1024;
        this.messageCount = 1000;
        this.doMultipleClientsTest();
        this.assertTotalMessagesReceived(this.messageCount * this.consumerCount * this.producerCount);
        this.assertDestinationMemoryUsageGoesToZero();
    }

    @Override
    @Test(timeout=60000L)
    public void testOneProducerTwoConsumersSmallMessagesLargePrefetch() throws Exception {
        this.consumerCount = 2;
        this.producerCount = 1;
        this.messageCount = 1000;
        this.messageSize = 1024;
        this.prefetchCount = this.messageCount * 2;
        this.doMultipleClientsTest();
        this.assertTotalMessagesReceived(this.messageCount * this.consumerCount * this.producerCount);
    }

    @Override
    @Test(timeout=60000L)
    public void testOneProducerTwoConsumersLargeMessagesLargePrefetch() throws Exception {
        this.consumerCount = 2;
        this.producerCount = 1;
        this.messageCount = 10;
        this.messageSize = 0x100000;
        this.prefetchCount = this.messageCount * 2;
        this.doMultipleClientsTest();
        this.assertTotalMessagesReceived(this.messageCount * this.consumerCount * this.producerCount);
        this.assertDestinationMemoryUsageGoesToZero();
    }

    @Override
    @Test(timeout=60000L)
    public void testOneProducerManyConsumersFewMessages() throws Exception {
        this.consumerCount = 50;
        this.producerCount = 1;
        this.messageCount = 10;
        this.messageSize = 1;
        this.prefetchCount = 10;
        this.doMultipleClientsTest();
        this.assertTotalMessagesReceived(this.messageCount * this.consumerCount * this.producerCount);
        this.assertDestinationMemoryUsageGoesToZero();
    }

    @Override
    @Test(timeout=60000L)
    public void testOneProducerManyConsumersManyMessages() throws Exception {
        this.consumerCount = 50;
        this.producerCount = 1;
        this.messageCount = 100;
        this.messageSize = 1;
        this.prefetchCount = 10;
        this.doMultipleClientsTest();
        this.assertTotalMessagesReceived(this.messageCount * this.consumerCount * this.producerCount);
        this.assertDestinationMemoryUsageGoesToZero();
    }

    @Override
    @Test(timeout=60000L)
    public void testManyProducersOneConsumer() throws Exception {
        this.consumerCount = 1;
        this.producerCount = 20;
        this.messageCount = 100;
        this.messageSize = 1;
        this.prefetchCount = 10;
        this.doMultipleClientsTest();
        this.assertTotalMessagesReceived(this.messageCount * this.producerCount * this.consumerCount);
        this.assertDestinationMemoryUsageGoesToZero();
    }
}

