/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.scheduler;

import java.util.Date;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.broker.scheduler.JobScheduler;
import org.apache.activemq.broker.scheduler.JobSchedulerTestSupport;
import org.apache.activemq.broker.scheduler.SchedulerBroker;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsCronSchedulerTest
extends JobSchedulerTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(JmsCronSchedulerTest.class);

    @Test
    public void testSimulatenousCron() throws Exception {
        int COUNT = 10;
        final AtomicInteger count = new AtomicInteger();
        Connection connection = this.createConnection();
        Session session = connection.createSession(false, 1);
        MessageConsumer consumer = session.createConsumer((Destination)this.destination);
        final CountDownLatch latch = new CountDownLatch(10);
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                count.incrementAndGet();
                latch.countDown();
                Assert.assertTrue((boolean)(message instanceof TextMessage));
                TextMessage tm = (TextMessage)message;
                try {
                    LOG.info("Received [{}] count: {} ", (Object)tm.getText(), (Object)count.get());
                }
                catch (JMSException e) {
                    LOG.error("Unexpected exception in onMessage", (Throwable)e);
                    Assert.fail((String)("Unexpected exception in onMessage: " + e.getMessage()));
                }
            }
        });
        connection.start();
        for (int i = 0; i < 10; ++i) {
            MessageProducer producer = session.createProducer((Destination)this.destination);
            TextMessage message = session.createTextMessage("test msg " + i);
            message.setStringProperty("AMQ_SCHEDULED_CRON", "* * * * *");
            producer.send((Message)message);
            LOG.info("Message {} sent at {}", (Object)i, (Object)new Date().toString());
            producer.close();
            Thread.sleep(2000L);
        }
        SchedulerBroker sb = (SchedulerBroker)this.broker.getBroker().getAdaptor(SchedulerBroker.class);
        JobScheduler js = sb.getJobScheduler();
        List list = js.getAllJobs();
        Assert.assertEquals((long)10L, (long)list.size());
        latch.await(2L, TimeUnit.MINUTES);
        Assert.assertEquals((long)10L, (long)count.get());
        connection.close();
    }

    @Test
    public void testCronScheduleWithTtlSet() throws Exception {
        Connection connection = this.createConnection();
        Session session = connection.createSession(false, 1);
        MessageConsumer consumer = session.createConsumer((Destination)this.destination);
        connection.start();
        MessageProducer producer = session.createProducer((Destination)this.destination);
        producer.setTimeToLive(TimeUnit.MINUTES.toMillis(1L));
        TextMessage message = session.createTextMessage("test msg ");
        message.setStringProperty("AMQ_SCHEDULED_CRON", "* * * * *");
        producer.send((Message)message);
        producer.close();
        Thread.sleep(TimeUnit.MINUTES.toMillis(2L));
        Assert.assertNotNull((Object)consumer.receiveNoWait());
        Assert.assertNull((Object)consumer.receiveNoWait());
        connection.close();
    }
}

