/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ3529Test {
    private static Logger LOG = LoggerFactory.getLogger(AMQ3529Test.class);
    private ConnectionFactory connectionFactory;
    private Connection connection;
    private Session session;
    private BrokerService broker;
    private String connectionUri;
    private MessageConsumer consumer;
    private Context ctx = null;

    @Before
    public void startBroker() throws Exception {
        this.broker = new BrokerService();
        this.broker.setDeleteAllMessagesOnStartup(true);
        this.broker.setPersistent(false);
        this.broker.setUseJmx(false);
        this.broker.addConnector("tcp://0.0.0.0:0");
        this.broker.start();
        this.broker.waitUntilStarted();
        this.connectionUri = ((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString();
        this.connectionFactory = new ActiveMQConnectionFactory(this.connectionUri);
    }

    @After
    public void stopBroker() throws Exception {
        this.broker.stop();
        this.broker.waitUntilStopped();
    }

    @Test(timeout=60000L)
    public void testInterruptionAffects() throws Exception {
        ThreadGroup tg = new ThreadGroup("tg");
        Assert.assertEquals((long)0L, (long)tg.activeCount());
        Thread client = new Thread(tg, "client"){

            @Override
            public void run() {
                try {
                    AMQ3529Test.this.connection = AMQ3529Test.this.connectionFactory.createConnection();
                    AMQ3529Test.this.session = AMQ3529Test.this.connection.createSession(false, 1);
                    Assert.assertNotNull((Object)AMQ3529Test.this.session);
                    Properties props = new Properties();
                    props.setProperty("java.naming.factory.initial", "org.apache.activemq.jndi.ActiveMQInitialContextFactory");
                    props.setProperty("java.naming.provider.url", "tcp://0.0.0.0:0");
                    AMQ3529Test.this.ctx = null;
                    try {
                        AMQ3529Test.this.ctx = new InitialContext(props);
                    }
                    catch (NoClassDefFoundError e) {
                        throw new NamingException(e.toString());
                    }
                    catch (Exception e) {
                        throw new NamingException(e.toString());
                    }
                    Destination destination = (Destination)AMQ3529Test.this.ctx.lookup("dynamicTopics/example.C");
                    AMQ3529Test.this.consumer = AMQ3529Test.this.session.createConsumer(destination);
                    AMQ3529Test.this.consumer.receive(10000L);
                }
                catch (Exception e) {
                }
                finally {
                    try {
                        AMQ3529Test.this.consumer.close();
                    }
                    catch (JMSException e) {
                        Assert.fail((String)("Consumer Close failed with" + e.getMessage()));
                    }
                    try {
                        AMQ3529Test.this.session.close();
                    }
                    catch (JMSException e) {
                        Assert.fail((String)("Session Close failed with" + e.getMessage()));
                    }
                    try {
                        AMQ3529Test.this.connection.close();
                    }
                    catch (JMSException e) {
                        Assert.fail((String)("Connection Close failed with" + e.getMessage()));
                    }
                    try {
                        AMQ3529Test.this.ctx.close();
                    }
                    catch (Exception e) {
                        Assert.fail((String)("Connection Close failed with" + e.getMessage()));
                    }
                }
            }
        };
        client.start();
        Thread.sleep(5000L);
        client.interrupt();
        client.join();
        Thread.sleep(2000L);
        Thread[] remainThreads = new Thread[tg.activeCount()];
        tg.enumerate(remainThreads);
        for (Thread t : remainThreads) {
            if (!t.isAlive() || t.isDaemon()) continue;
            Assert.fail((String)("Remaining thread: " + t.toString()));
        }
        ThreadGroup root = Thread.currentThread().getThreadGroup().getParent();
        while (root.getParent() != null) {
            root = root.getParent();
        }
        AMQ3529Test.visit(root, 0);
    }

    public static void visit(ThreadGroup group, int level) {
        int numThreads = group.activeCount();
        Thread[] threads = new Thread[numThreads * 2];
        numThreads = group.enumerate(threads, false);
        for (int i = 0; i < numThreads; ++i) {
            Thread thread = threads[i];
            LOG.debug("Thread:" + thread.getName() + " is still running");
        }
        int numGroups = group.activeGroupCount();
        ThreadGroup[] groups = new ThreadGroup[numGroups * 2];
        numGroups = group.enumerate(groups, false);
        for (int i = 0; i < numGroups; ++i) {
            AMQ3529Test.visit(groups[i], level + 1);
        }
    }
}

