/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.util.LinkedList;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.util.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ3529v2Test {
    private static Logger LOG = LoggerFactory.getLogger(AMQ3529v2Test.class);
    private BrokerService broker;
    private String connectionUri;

    @Before
    public void startBroker() throws Exception {
        this.broker = new BrokerService();
        this.broker.setDeleteAllMessagesOnStartup(true);
        this.broker.setPersistent(false);
        this.broker.setUseJmx(false);
        this.broker.addConnector("tcp://0.0.0.0:0");
        this.broker.start();
        this.broker.waitUntilStarted();
        this.connectionUri = ((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString();
    }

    @After
    public void stopBroker() throws Exception {
        this.broker.stop();
        this.broker.waitUntilStopped();
    }

    @Test(timeout=60000L)
    public void testRandomInterruptionAffects() throws Exception {
        this.doTestRandomInterruptionAffects();
    }

    @Test(timeout=60000L)
    public void testRandomInterruptionAffectsWithFailover() throws Exception {
        this.connectionUri = "failover:(" + this.connectionUri + ")";
        this.doTestRandomInterruptionAffects();
    }

    /*
     * WARNING - void declaration
     */
    public void doTestRandomInterruptionAffects() throws Exception {
        void var7_19;
        final ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.connectionUri);
        ThreadGroup tg = new ThreadGroup("tg");
        Assert.assertEquals((long)0L, (long)tg.activeCount());
        final Random random = new Random();
        class ClientThread
        extends Thread {
            public Exception error;

            public ClientThread(ThreadGroup tg, String name) {
                super(tg, name);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Context ctx = null;
                Connection connection = null;
                Session session = null;
                MessageConsumer consumer = null;
                try {
                    connection = connectionFactory.createConnection();
                    session = connection.createSession(false, 1);
                    Assert.assertNotNull((Object)session);
                    Properties props = new Properties();
                    props.setProperty("java.naming.factory.initial", "org.apache.activemq.jndi.ActiveMQInitialContextFactory");
                    props.setProperty("java.naming.provider.url", AMQ3529v2Test.this.connectionUri);
                    ctx = null;
                    try {
                        ctx = new InitialContext(props);
                    }
                    catch (NoClassDefFoundError e) {
                        throw new NamingException(e.toString());
                    }
                    catch (Exception e) {
                        throw new NamingException(e.toString());
                    }
                    Destination destination = (Destination)ctx.lookup("dynamicTopics/example.C");
                    consumer = session.createConsumer(destination);
                    consumer.receive(10000L);
                }
                catch (Exception e) {
                }
                finally {
                    try {
                        if (consumer != null) {
                            consumer.close();
                        }
                    }
                    catch (JMSException e) {
                        this.trackException("Consumer Close failed with", (Exception)((Object)e));
                    }
                    try {
                        if (session != null) {
                            session.close();
                        }
                    }
                    catch (JMSException e) {
                        this.trackException("Session Close failed with", (Exception)((Object)e));
                    }
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (JMSException e) {
                        this.trackException("Connection Close failed with", (Exception)((Object)e));
                    }
                    try {
                        if (ctx != null) {
                            ctx.close();
                        }
                    }
                    catch (Exception e) {
                        this.trackException("Connection Close failed with", e);
                    }
                }
            }

            private void trackException(String s, Exception e) {
                LOG.error(s, (Throwable)e);
                this.error = e;
            }
        }
        LinkedList<ClientThread> threads = new LinkedList<ClientThread>();
        for (int i = 0; i < 10; ++i) {
            threads.add(new ClientThread(tg, "Client-" + i));
        }
        for (Thread thread : threads) {
            thread.start();
        }
        ExecutorService doTheInterrupts = Executors.newFixedThreadPool(threads.size());
        for (final Thread thread : threads) {
            doTheInterrupts.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(random.nextInt(5000));
                    }
                    catch (InterruptedException ignored) {
                        ignored.printStackTrace();
                    }
                    thread.interrupt();
                }
            });
        }
        doTheInterrupts.shutdown();
        TestCase.assertTrue((String)"all interrupts done", (boolean)doTheInterrupts.awaitTermination(30L, TimeUnit.SECONDS));
        for (Thread thread : threads) {
            thread.join();
        }
        for (ClientThread clientThread : threads) {
            if (clientThread.error == null) continue;
            LOG.info("Close error on thread: " + clientThread, (Throwable)clientThread.error);
        }
        Thread[] threadArray = new Thread[tg.activeCount()];
        tg.enumerate(threadArray);
        for (final Thread t : threadArray) {
            if (t == null || !t.isAlive() || t.isDaemon()) continue;
            TestCase.assertTrue((String)("Thread completes:" + t), (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

                public boolean isSatisified() throws Exception {
                    LOG.info("Remaining thread: " + t.toString());
                    return !t.isAlive();
                }
            }));
        }
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup().getParent();
        while (var7_19.getParent() != null) {
            ThreadGroup threadGroup2 = var7_19.getParent();
        }
        AMQ3529v2Test.visit((ThreadGroup)var7_19, 0);
    }

    public static void visit(ThreadGroup group, int level) {
        int numThreads = group.activeCount();
        Thread[] threads = new Thread[numThreads * 2];
        numThreads = group.enumerate(threads, false);
        for (int i = 0; i < numThreads; ++i) {
            Thread thread = threads[i];
            LOG.debug("Thread:" + thread.getName() + " is still running");
        }
        int numGroups = group.activeGroupCount();
        ThreadGroup[] groups = new ThreadGroup[numGroups * 2];
        numGroups = group.enumerate(groups, false);
        for (int i = 0; i < numGroups; ++i) {
            AMQ3529v2Test.visit(groups[i], level + 1);
        }
    }
}

