/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.IOException;
import java.util.ArrayList;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.FilteredKahaDBPersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.store.kahadb.MultiKahaDBPersistenceAdapter;
import org.apache.activemq.util.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ4407Test {
    static final Logger LOG = LoggerFactory.getLogger(AMQ4407Test.class);
    private static final int maxFileLength = 0x2000000;
    private static final String PREFIX_DESTINATION_NAME = "queue";
    private static final String DESTINATION_NAME = "queue.test";
    private static final String DESTINATION_NAME_2 = "queue2.test";
    private static final String DESTINATION_NAME_3 = "queue3.test";
    BrokerService broker;

    @Before
    public void setUp() throws Exception {
        this.prepareBrokerWithMultiStore(true);
        this.broker.start();
        this.broker.waitUntilStarted();
    }

    @After
    public void tearDown() throws Exception {
        this.broker.stop();
    }

    protected BrokerService createBroker(PersistenceAdapter kaha) throws Exception {
        BrokerService broker = new BrokerService();
        broker.setUseJmx(true);
        broker.setBrokerName("localhost");
        broker.setPersistenceAdapter(kaha);
        return broker;
    }

    @Test
    public void testRestartAfterQueueDelete() throws Exception {
        Assert.assertTrue((String)"Broker doesn't have an Admin View.", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return AMQ4407Test.this.broker.getAdminView() != null;
            }
        }));
        LOG.info("Adding destinations: {}, {}, {}", new Object[]{DESTINATION_NAME, DESTINATION_NAME_3, DESTINATION_NAME_3});
        this.sendMessage(DESTINATION_NAME, "test 1");
        this.sendMessage(DESTINATION_NAME_2, "test 1");
        this.sendMessage(DESTINATION_NAME_3, "test 1");
        Assert.assertNotNull((Object)this.broker.getDestination((ActiveMQDestination)new ActiveMQQueue(DESTINATION_NAME)));
        Assert.assertNotNull((Object)this.broker.getDestination((ActiveMQDestination)new ActiveMQQueue(DESTINATION_NAME_2)));
        Assert.assertNotNull((Object)this.broker.getDestination((ActiveMQDestination)new ActiveMQQueue(DESTINATION_NAME_3)));
        LOG.info("Removing destination: {}", (Object)DESTINATION_NAME_2);
        this.broker.getAdminView().removeQueue(DESTINATION_NAME_2);
        LOG.info("Recreating destination: {}", (Object)DESTINATION_NAME_2);
        this.sendMessage(DESTINATION_NAME_2, "test 1");
        org.apache.activemq.broker.region.Destination destination2 = this.broker.getDestination((ActiveMQDestination)new ActiveMQQueue(DESTINATION_NAME_2));
        Assert.assertNotNull((Object)destination2);
        Assert.assertEquals((long)1L, (long)destination2.getMessageStore().getMessageCount());
    }

    @Test
    public void testRemoveOfOneDestFromSharedPa() throws Exception {
        Assert.assertTrue((String)"Broker doesn't have an Admin View.", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return AMQ4407Test.this.broker.getAdminView() != null;
            }
        }));
        this.sendMessage("queue.A", "test 1");
        this.sendMessage("queue.B", "test 1");
        this.broker.getAdminView().removeQueue("queue.A");
        this.sendMessage("queue.B", "test 1");
        org.apache.activemq.broker.region.Destination destination2 = this.broker.getDestination((ActiveMQDestination)new ActiveMQQueue("queue.B"));
        Assert.assertNotNull((Object)destination2);
        Assert.assertEquals((long)2L, (long)destination2.getMessageStore().getMessageCount());
    }

    protected KahaDBPersistenceAdapter createStore(boolean delete) throws IOException {
        KahaDBPersistenceAdapter kaha = new KahaDBPersistenceAdapter();
        kaha.setJournalMaxFileLength(0x2000000);
        kaha.setCleanupInterval(5000L);
        if (delete) {
            kaha.deleteAllMessages();
        }
        return kaha;
    }

    public void prepareBrokerWithMultiStore(boolean deleteAllMessages) throws Exception {
        MultiKahaDBPersistenceAdapter multiKahaDBPersistenceAdapter = new MultiKahaDBPersistenceAdapter();
        if (deleteAllMessages) {
            multiKahaDBPersistenceAdapter.deleteAllMessages();
        }
        ArrayList<FilteredKahaDBPersistenceAdapter> adapters = new ArrayList<FilteredKahaDBPersistenceAdapter>();
        adapters.add(this.createFilteredKahaDBByDestinationPrefix(PREFIX_DESTINATION_NAME, deleteAllMessages));
        adapters.add(this.createFilteredKahaDBByDestinationPrefix("queue2", deleteAllMessages));
        adapters.add(this.createFilteredKahaDBByDestinationPrefix(null, deleteAllMessages));
        multiKahaDBPersistenceAdapter.setFilteredPersistenceAdapters(adapters);
        this.broker = this.createBroker((PersistenceAdapter)multiKahaDBPersistenceAdapter);
    }

    private FilteredKahaDBPersistenceAdapter createFilteredKahaDBByDestinationPrefix(String destinationPrefix, boolean deleteAllMessages) throws IOException {
        FilteredKahaDBPersistenceAdapter template = new FilteredKahaDBPersistenceAdapter();
        template.setPersistenceAdapter((PersistenceAdapter)this.createStore(deleteAllMessages));
        if (destinationPrefix != null) {
            template.setQueue(destinationPrefix + ".>");
        }
        return template;
    }

    private void sendMessage(String destinationName, String message) throws JMSException {
        ActiveMQConnectionFactory f = new ActiveMQConnectionFactory("vm://localhost");
        f.setAlwaysSyncSend(true);
        Connection c = f.createConnection();
        c.start();
        Session s = c.createSession(false, 1);
        MessageProducer producer = s.createProducer((Destination)new ActiveMQQueue(destinationName));
        producer.send((Message)s.createTextMessage(message));
        producer.close();
        s.close();
        c.stop();
    }
}

