/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerRegistry;
import org.apache.activemq.broker.BrokerService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AMQ5136Test {
    BrokerService brokerService;

    @Before
    public void startBroker() throws Exception {
        this.brokerService = new BrokerService();
        this.brokerService.setPersistent(false);
        this.brokerService.setUseJmx(false);
        this.brokerService.start();
    }

    @After
    public void stopBroker() throws Exception {
        this.brokerService.stop();
    }

    @Test
    public void memoryUsageOnCommit() throws Exception {
        this.sendMessagesAndAssertMemoryUsage(new TransactionHandler(){

            @Override
            public void finishTransaction(Session session) throws JMSException {
                session.commit();
            }
        });
    }

    @Test
    public void memoryUsageOnRollback() throws Exception {
        this.sendMessagesAndAssertMemoryUsage(new TransactionHandler(){

            @Override
            public void finishTransaction(Session session) throws JMSException {
                session.rollback();
            }
        });
    }

    private void sendMessagesAndAssertMemoryUsage(TransactionHandler transactionHandler) throws Exception {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("vm://localhost");
        Connection connection = connectionFactory.createConnection();
        Session session = connection.createSession(true, 0);
        Topic destination = session.createTopic("ActiveMQBug");
        MessageProducer producer = session.createProducer((Destination)destination);
        for (int i = 0; i < 100; ++i) {
            BytesMessage message = session.createBytesMessage();
            message.writeBytes(this.generateBytes());
            producer.send((Message)message);
            transactionHandler.finishTransaction(session);
        }
        connection.close();
        Assert.assertEquals((long)0L, (long)BrokerRegistry.getInstance().findFirst().getSystemUsage().getMemoryUsage().getPercentUsage());
    }

    private byte[] generateBytes() {
        byte[] bytes = new byte[100000];
        for (int i = 0; i < 100000; ++i) {
            bytes[i] = (byte)i;
        }
        return bytes;
    }

    private static interface TransactionHandler {
        public void finishTransaction(Session var1) throws JMSException;
    }
}

