/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.Serializable;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.bugs.AMQ5921MessagePayload;
import org.apache.activemq.command.ActiveMQObjectMessage;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ5921Test {
    private static Logger LOG = LoggerFactory.getLogger(AMQ5921Test.class);
    private ActiveMQConnection connection;
    private BrokerService broker;
    private String connectionUri;
    @Rule
    public TestName name = new TestName();

    @Test
    public void testVoidSupport() throws Exception {
        this.sendMessage();
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        Queue destination = session.createQueue(this.name.getMethodName());
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        ActiveMQObjectMessage msg = (ActiveMQObjectMessage)consumer.receive();
        AMQ5921MessagePayload payload = (AMQ5921MessagePayload)msg.getObject();
        LOG.info("Received: {}", payload.getField1());
        session.close();
    }

    @Before
    public void setUp() throws Exception {
        this.broker = new BrokerService();
        this.broker.setUseJmx(false);
        this.broker.setPersistent(false);
        this.broker.addConnector("tcp://localhost:0");
        this.broker.start();
        this.broker.waitUntilStarted();
        this.connectionUri = ((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString();
        this.connection = this.createConnection();
    }

    @After
    public void tearDown() throws Exception {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.broker != null) {
            this.broker.stop();
            this.broker.waitUntilStopped();
        }
    }

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory(this.connectionUri);
    }

    protected ActiveMQConnection createConnection() throws Exception {
        return (ActiveMQConnection)this.createConnectionFactory().createConnection();
    }

    private void sendMessage() throws Exception {
        AMQ5921MessagePayload msgPayload = new AMQ5921MessagePayload();
        msgPayload.setField1(Void.TYPE);
        Session session = this.connection.createSession(false, 1);
        Queue destination = session.createQueue(this.name.getMethodName());
        MessageProducer producer = session.createProducer((Destination)destination);
        producer.setDeliveryMode(1);
        ObjectMessage message = session.createObjectMessage();
        message.setObject((Serializable)msgPayload);
        producer.send((Message)message);
        session.close();
    }
}

